/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISSerializeInventory;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISDiskWriterCommand {
    private static final Pattern LETTERS_NUMBERS = Pattern.compile("[A-Za-z0-9_*]{2,16}");
    private final TARDIS plugin;
    private final List<String> disks = new ArrayList<String>();

    public TARDISDiskWriterCommand(TARDIS plugin) {
        this.plugin = plugin;
        this.disks.add("Save Storage Disk");
        this.disks.add("Player Storage Disk");
        this.disks.add("Biome Storage Disk");
        this.disks.add("Preset Storage Disk");
    }

    public boolean writeSave(Player player, String[] args) {
        ItemMeta im;
        ItemStack is;
        boolean makeAndSaveDisk;
        boolean bl = makeAndSaveDisk = !this.plugin.getConfig().getBoolean("difficulty.disk_in_hand_for_write");
        if (makeAndSaveDisk) {
            is = ItemStack.of((Material)Material.MUSIC_DISC_CHIRP, (int)1);
            im = is.getItemMeta();
            im.displayName((Component)Component.text((String)"Save Storage Disk"));
            im.lore(List.of(Component.text((String)"Blank")));
            is.setItemMeta(im);
        } else {
            is = player.getInventory().getItemInMainHand();
        }
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Save Storage Disk")) {
            boolean isSpace;
            List lore = im.lore();
            if (!ComponentUtils.stripColour((Component)lore.getFirst()).equals("Blank")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_ONLY_BLANK");
                return true;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            if (!LETTERS_NUMBERS.matcher(args[1]).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NAME_NOT_VALID");
                return false;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return false;
            }
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            ChameleonPreset preset = tardis.getPreset();
            HashMap<String, Object> wherename = new HashMap<String, Object>();
            wherename.put("tardis_id", id);
            wherename.put("dest_name", args[1]);
            wherename.put("type", 0);
            ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, wherename, false);
            if (rsd.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_EXISTS");
                return true;
            }
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                return true;
            }
            Current current = rsc.getCurrent();
            lore.set(0, Component.text((String)args[1]));
            lore.add(1, Component.text((String)current.location().getWorld().getName()));
            lore.add(2, Component.text((int)current.location().getBlockX()));
            lore.add(3, Component.text((int)current.location().getBlockY()));
            lore.add(4, Component.text((int)current.location().getBlockZ()));
            lore.add(5, Component.text((String)preset.toString()));
            lore.add(6, Component.text((String)current.direction().toString()));
            lore.add(7, Component.text((String)(current.submarine() ? "true" : "false")));
            im.lore(lore);
            is.setItemMeta(im);
            if (makeAndSaveDisk && !(isSpace = this.saveDiskToStorage(player, is))) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_STORAGE_FULL");
                return true;
            }
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_LOC_SAVED");
            return true;
        }
        return true;
    }

    private boolean saveDiskToStorage(Player player, ItemStack is) {
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetDiskStorage rs = new ResultSetDiskStorage(this.plugin, where);
        if (rs.resultSet()) {
            try {
                ItemStack[] saves1 = TARDISSerializeInventory.itemStacksFromString(rs.getSavesOne());
                int slot = this.getNextFreeSlot(saves1);
                if (slot != -1) {
                    saves1[slot] = is;
                    String serialized = TARDISSerializeInventory.itemStacksToString(saves1);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("saves_one", serialized);
                    HashMap<String, Object> whereu = new HashMap<String, Object>();
                    whereu.put("uuid", uuid.toString());
                    this.plugin.getQueryFactory().doUpdate("storage", set, whereu);
                    return true;
                }
                ItemStack[] saves2 = TARDISSerializeInventory.itemStacksFromString(rs.getSavesTwo());
                slot = this.getNextFreeSlot(saves2);
                if (slot != -1) {
                    saves2[slot] = is;
                    String serialized = TARDISSerializeInventory.itemStacksToString(saves2);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("saves_two", serialized);
                    HashMap<String, Object> whereu = new HashMap<String, Object>();
                    whereu.put("uuid", uuid.toString());
                    this.plugin.getQueryFactory().doUpdate("storage", set, whereu);
                    return true;
                }
                return false;
            }
            catch (IOException ex) {
                this.plugin.debug("Could not get save disks: " + String.valueOf(ex));
            }
        }
        return false;
    }

    private int getNextFreeSlot(ItemStack[] stack) {
        int slot = -1;
        for (int s = 27; s < stack.length; ++s) {
            ItemStack disk = stack[s];
            if (disk != null) continue;
            slot = s;
            break;
        }
        return slot;
    }

    public boolean writePlayer(Player player, String[] args) {
        ItemMeta im;
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Player Storage Disk")) {
            List lore = im.lore();
            if (!ComponentUtils.stripColour((Component)lore.getFirst()).equals("Blank")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_ONLY_BLANK");
                return true;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            if (!LETTERS_NUMBERS.matcher(args[1]).matches()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PLAYER_NOT_VALID");
                return false;
            }
            if (player.getName().equalsIgnoreCase(args[1])) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_NO_SAVE");
                return true;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return false;
            }
            lore.set(0, Component.text((String)args[1]));
            im.lore(lore);
            is.setItemMeta(im);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_PLAYER_SAVED");
            return true;
        }
        return true;
    }

    public boolean eraseDisk(Player player) {
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.hasItemMeta() && this.disks.contains(is.getItemMeta().displayName())) {
            ItemMeta im = is.getItemMeta();
            im.lore(List.of(Component.text((String)"Blank")));
            is.setItemMeta(im);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_ERASE");
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_HAND_ERASE");
        }
        return true;
    }

    public boolean writeSaveToControlDisk(Player player, String[] args) {
        ItemMeta im;
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Authorised Control Disk") && im.getPersistentDataContainer().has(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID())) {
            String save;
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_TARDIS");
                return false;
            }
            if (args[1].equalsIgnoreCase("home")) {
                save = "Home";
            } else {
                HashMap<String, Object> wherename = new HashMap<String, Object>();
                wherename.put("tardis_id", rs.getTardisId());
                wherename.put("dest_name", args[1]);
                wherename.put("type", 0);
                ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, wherename, false);
                if (!rsd.resultSet()) {
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_NOT_FOUND", "/tardis list saves", this.plugin);
                    return true;
                }
                save = args[1];
            }
            List lore = im.lore();
            lore.add(Component.text((String)save));
            im.lore(lore);
            is.setItemMeta(im);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_LOC_SAVED");
            return true;
        }
        return true;
    }
}

