/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.SmelterChest;

public class ResultSetVault {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private int vault_id;
    private int tardis_id;
    private String location;
    private SmelterChest chestType;
    private int x;
    private int y;
    private int z;

    public ResultSetVault(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromLocation(String where) {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "vaults WHERE location = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, where);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.vault_id = rs.getInt("v_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.location = rs.getString("location");
                        this.chestType = SmelterChest.valueOf(rs.getString("chest_type"));
                        this.x = rs.getInt("x");
                        this.y = rs.getInt("y");
                        this.z = rs.getInt("z");
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for vaults table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing vaults table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromId(int id) {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "vaults WHERE id = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, id);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.vault_id = rs.getInt("v_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.location = rs.getString("location");
                        this.chestType = SmelterChest.valueOf(rs.getString("chest_type"));
                        this.x = rs.getInt("x");
                        this.y = rs.getInt("y");
                        this.z = rs.getInt("z");
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for vaults table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing vaults table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromIdAndChestType(int id, SmelterChest chestType) {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "vaults WHERE tardis_id = ? AND chest_type = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, id);
                statement.setString(2, chestType.toString());
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.vault_id = rs.getInt("v_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.location = rs.getString("location");
                        chestType = SmelterChest.valueOf(rs.getString("chest_type"));
                        this.x = rs.getInt("x");
                        this.y = rs.getInt("y");
                        this.z = rs.getInt("z");
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for vaults table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing vaults table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getVault_id() {
        return this.vault_id;
    }

    public int getTardis_id() {
        return this.tardis_id;
    }

    public String getLocation() {
        return this.location;
    }

    public SmelterChest getChestType() {
        return this.chestType;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }
}

