/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.universaltranslator;

import java.util.Arrays;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.universaltranslator.Language;
import me.eccentric_nz.TARDIS.universaltranslator.LingvaTranslate;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISSayCommand
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISSayCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardissay")) {
            Player player;
            ResultSetPlayerPrefs rs;
            if (!TARDISPermission.hasPermission(sender, "tardis.translate")) {
                this.plugin.getMessenger().send(sender, TardisModule.TRANSLATOR, "NO_PERMS");
                return false;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send(sender, TardisModule.TRANSLATOR, "TOO_FEW_ARGS");
                return false;
            }
            String preferedLang = "ENGLISH";
            if (sender instanceof Player && (rs = new ResultSetPlayerPrefs(this.plugin, (player = (Player)sender).getUniqueId().toString())).resultSet() && !rs.getLanguage().isEmpty() && !rs.getLanguage().equalsIgnoreCase("AUTO_DETECT")) {
                preferedLang = rs.getLanguage();
            }
            String whatToTranslate = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
            String lang = args[0].toUpperCase(Locale.ROOT);
            try {
                Language from = Language.valueOf(preferedLang);
                Language to = Language.valueOf(lang);
                try {
                    LingvaTranslate translate = new LingvaTranslate(this.plugin, from.getCode(), to.getCode(), whatToTranslate);
                    translate.fetchAsync((hasResult, translated) -> {
                        if (hasResult) {
                            this.plugin.getServer().dispatchCommand(sender, "say [" + TardisModule.TRANSLATOR.getName() + "] " + translated.getTranslated());
                        }
                    });
                    return true;
                }
                catch (CommandException ex) {
                    this.plugin.debug("Could not get translation! " + ex.getMessage());
                    this.plugin.getMessenger().send(sender, TardisModule.TRANSLATOR, "YT_UNAVAILABLE");
                }
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send(sender, TardisModule.TRANSLATOR, "LANG_NOT_VALID");
            }
        }
        return false;
    }
}

