/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.microscope;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.Specimen;
import me.eccentric_nz.tardischemistry.microscope.LabEquipment;
import me.eccentric_nz.tardischemistry.microscope.MicroscopeUtils;
import org.bukkit.Rotation;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class MicroscopeInteractListener
implements Listener {
    private final TARDIS plugin;

    MicroscopeInteractListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getHand() != null && event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack is = player.getInventory().getItemInMainHand();
        if (!is.getType().isAir() && LabEquipment.getByMaterial().containsKey(is.getType())) {
            ItemMeta im = is.getItemMeta();
            if (im == null) {
                return;
            }
            if (!im.hasDisplayName()) {
                return;
            }
            if (!im.hasItemModel()) {
                return;
            }
            Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            if (!block.getType().isSolid()) {
                return;
            }
            Block up = block.getRelative(BlockFace.UP);
            if (!up.getType().isAir()) {
                return;
            }
            World world = up.getWorld();
            ItemFrame frame = (ItemFrame)world.spawnEntity(up.getLocation(), EntityType.ITEM_FRAME);
            frame.setFacingDirection(BlockFace.UP);
            frame.setRotation(this.fromPlayersFacing(player));
            frame.setVisible(false);
            ItemStack equipment = is.clone();
            equipment.setAmount(1);
            frame.setItem(equipment);
            frame.getPersistentDataContainer().set(this.plugin.getMicroscopeKey(), PersistentDataType.STRING, (Object)Specimen.EMPTY_SLIDE.getKey().getKey());
            MicroscopeUtils.reduceInHand(player);
        }
    }

    private Rotation fromPlayersFacing(Player player) {
        switch (player.getFacing()) {
            case NORTH: {
                return Rotation.FLIPPED;
            }
            case EAST: {
                return Rotation.COUNTER_CLOCKWISE;
            }
            case SOUTH: {
                return Rotation.NONE;
            }
            case WEST: {
                return Rotation.CLOCKWISE;
            }
        }
        return Rotation.CLOCKWISE_45;
    }
}

