/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.product;

import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.Material;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class BalloonListener
implements Listener {
    private final TARDIS plugin;

    public BalloonListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerHoldBalloon(PlayerItemHeldEvent event) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Player player = event.getPlayer();
            int factor = -1;
            if (this.isBalloon(player.getInventory().getItemInMainHand())) {
                ++factor;
            }
            if (this.isBalloon(player.getInventory().getItemInOffHand())) {
                ++factor;
            }
            this.removeJumpBoost(player);
            if (factor > -1) {
                PotionEffect potionEffect = new PotionEffect(PotionEffectType.JUMP_BOOST, Integer.MAX_VALUE, factor);
                player.addPotionEffect(potionEffect);
            }
        }, 1L);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDropBalloon(PlayerDropItemEvent event) {
        if (this.isBalloon(event.getItemDrop().getItemStack())) {
            Player player = event.getPlayer();
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                if (!this.isBalloon(player.getInventory().getItemInMainHand())) {
                    this.removeJumpBoost(player);
                }
            }, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerPickupBalloon(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                int factor = -1;
                if (this.isBalloon(event.getItem().getItemStack())) {
                    if (this.isBalloon(player.getInventory().getItemInMainHand())) {
                        ++factor;
                    }
                    if (this.isBalloon(player.getInventory().getItemInOffHand())) {
                        ++factor;
                    }
                    this.removeJumpBoost(player);
                    if (factor > -1) {
                        PotionEffect potionEffect = new PotionEffect(PotionEffectType.JUMP_BOOST, Integer.MAX_VALUE, factor);
                        player.addPotionEffect(potionEffect);
                    }
                }
            }, 1L);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerMoveBalloon(InventoryClickEvent event) {
        if (this.isBalloon(event.getCursor()) || this.isBalloon(event.getCurrentItem()) || event.getClick() == ClickType.NUMBER_KEY) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                Player player = (Player)event.getWhoClicked();
                int factor = 1;
                if (!this.isBalloon(player.getInventory().getItemInMainHand())) {
                    --factor;
                }
                if (!this.isBalloon(player.getInventory().getItemInOffHand())) {
                    --factor;
                }
                if (factor > -1) {
                    PotionEffect potionEffect = new PotionEffect(PotionEffectType.JUMP_BOOST, Integer.MAX_VALUE, factor);
                    player.addPotionEffect(potionEffect);
                } else {
                    this.removeJumpBoost(player);
                }
            }, 1L);
        }
    }

    private boolean isBalloon(ItemStack is) {
        return is != null && is.getType().equals((Object)Material.CORNFLOWER) && is.hasItemMeta() && is.getItemMeta().hasItemModel() && is.getItemMeta().getItemModel().getKey().endsWith("_balloon");
    }

    private void removeJumpBoost(Player player) {
        PotionEffect potionEffect;
        if (player.hasPotionEffect(PotionEffectType.JUMP_BOOST) && (potionEffect = player.getPotionEffect(PotionEffectType.JUMP_BOOST)).getDuration() > 150000000) {
            player.removePotionEffect(PotionEffectType.JUMP_BOOST);
        }
    }
}

