/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.bStats;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.Consoles;

public class ARSRoomCounts {
    private static final Pattern JSON_FLUFF = Pattern.compile("[\"\\[\\]]");
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final List<String> STONE = List.of("STONE");
    private final List<Double> numberOfRoomsPerTARDIS = new ArrayList<Double>();

    public ARSRoomCounts(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Integer> getRoomCounts() {
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT json FROM " + this.prefix + "ars";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    String json = JSON_FLUFF.matcher(rs.getString("json")).replaceAll("");
                    double num = 0.0;
                    ArrayList<String> materials = new ArrayList<String>(List.of(json.split(",")));
                    materials.removeAll(this.STONE);
                    for (String material : materials) {
                        if (Consoles.getBY_MATERIALS().containsKey(material)) continue;
                        num += 1.0;
                        String room = TARDISARS.ARSFor(material).toString();
                        int count = data.containsKey(room) ? data.get(room) + 1 : 1;
                        data.put(room, count);
                    }
                    this.numberOfRoomsPerTARDIS.add(num);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for ars getting room counts! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing ars table getting room counts! " + e.getMessage());
            }
        }
        return data;
    }

    public String getMedian() {
        Collections.sort(this.numberOfRoomsPerTARDIS);
        double middle = this.numberOfRoomsPerTARDIS.size() % 2 == 0 ? (this.numberOfRoomsPerTARDIS.get(this.numberOfRoomsPerTARDIS.size() / 2) + this.numberOfRoomsPerTARDIS.get(this.numberOfRoomsPerTARDIS.size() / 2 - 1)) / 2.0 : this.numberOfRoomsPerTARDIS.get(this.numberOfRoomsPerTARDIS.size() / 2);
        return String.format("%.1f", middle);
    }
}

