/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.schematic.ResultSetArchive;

public class ResultSetTardisSize {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private ConsoleSize consoleSize = ConsoleSize.SMALL;

    public ResultSetTardisSize(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromUUID(String uuid) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT size FROM " + this.prefix + "tardis WHERE uuid = ? AND abandoned = 0";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, uuid);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                if (rs.getString("size").equals("ARCHIVE")) {
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("uuid", uuid);
                    where.put("use", 1);
                    ResultSetArchive rsa = new ResultSetArchive(this.plugin, where);
                    if (rsa.resultSet()) {
                        this.consoleSize = rsa.getArchive().getConsoleSize();
                    }
                } else {
                    this.consoleSize = Consoles.getBY_NAMES().get(rs.getString("size")).getConsoleSize();
                }
                boolean where = true;
                return where;
            }
            boolean where = false;
            return where;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for tardis [tardis_id fromUUID] table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis [tardis_id fromUUID] table! " + e.getMessage());
            }
        }
    }

    public ConsoleSize getConsoleSize() {
        return this.consoleSize;
    }
}

