/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.hads;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.event.TARDISHADSEvent;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISStainedGlassLookup;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.HADS;
import me.eccentric_nz.TARDIS.hads.TARDISCloisterBell;
import me.eccentric_nz.TARDIS.hads.TARDISHostileDisplacement;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

class TARDISHostileDispersal {
    private final TARDIS plugin;
    private final List<Material> replace_with_barrier;

    TARDISHostileDispersal(TARDIS plugin) {
        this.plugin = plugin;
        this.replace_with_barrier = this.buildList();
    }

    void disperseTARDIS(int id, UUID uuid, Player hostile, ChameleonPreset preset) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (!rsc.resultSet()) {
            this.plugin.debug("Could not get current TARDIS location for HADS!");
            return;
        }
        Current current = rsc.getCurrent();
        if (current.submarine() || preset.usesArmourStand()) {
            new TARDISHostileDisplacement(this.plugin).moveTARDIS(id, uuid, hostile, preset);
            return;
        }
        TARDISCloisterBell bell = new TARDISCloisterBell(this.plugin, 3, id, current.location(), this.plugin.getServer().getPlayer(uuid), "HADS dispersal");
        int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)bell, 2L, 70L);
        bell.setTask(taskID);
        this.plugin.getTrackerKeeper().getCloisterBells().put(id, taskID);
        this.plugin.getTrackerKeeper().getPortals().remove(current.location());
        ResultSetTardisPreset rs = new ResultSetTardisPreset(this.plugin);
        if (rs.fromID(id)) {
            Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
            if (innerDisplayDoor.display()) {
                new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid, true);
            } else {
                new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, uuid);
            }
            boolean outerDisplayDoor = rs.getPreset().usesArmourStand();
            if (outerDisplayDoor) {
                new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, uuid);
            } else if (rs.getPreset().hasDoor()) {
                new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, uuid);
            }
        }
        World w = current.location().getWorld();
        Chunk chunk = w.getChunkAt(current.location());
        while (!chunk.isLoaded()) {
            chunk.load();
        }
        int sbx = current.location().getBlockX() - 1;
        int sby = preset.equals((Object)ChameleonPreset.SUBMERGED) ? current.location().getBlockY() - 1 : current.location().getBlockY();
        int sbz = current.location().getBlockZ() - 1;
        switch (preset) {
            case GRAVESTONE: {
                int flowerx;
                int flowery = current.location().getBlockY() + 1;
                TARDISBlockSetters.setBlock(w, flowerx, flowery, switch (current.direction()) {
                    case COMPASS.NORTH -> {
                        flowerx = current.location().getBlockX();
                        yield current.location().getBlockZ() + 1;
                    }
                    case COMPASS.WEST -> {
                        flowerx = current.location().getBlockX() + 1;
                        yield current.location().getBlockZ();
                    }
                    case COMPASS.SOUTH -> {
                        flowerx = current.location().getBlockX();
                        yield current.location().getBlockZ() - 1;
                    }
                    default -> {
                        flowerx = current.location().getBlockX() - 1;
                        yield current.location().getBlockZ();
                    }
                }, Material.AIR);
                break;
            }
            case DUCK: {
                this.plugin.getPresetDestroyer().destroyDuckEyes(current.location(), current.direction());
                break;
            }
            case MINESHAFT: {
                this.plugin.getPresetDestroyer().destroyMineshaftTorches(current.location(), current.direction());
                break;
            }
            case LAMP: {
                this.plugin.getPresetDestroyer().destroyLampTrapdoors(current.location(), current.direction());
                break;
            }
        }
        this.plugin.getTrackerKeeper().getDematerialising().remove(id);
        current.location().getChunk().removePluginChunkTicket((Plugin)this.plugin);
        this.plugin.getPresetDestroyer().destroyDoor(id);
        this.plugin.getPresetDestroyer().destroyLamp(current.location(), preset);
        this.plugin.getPresetDestroyer().destroySign(current.location(), current.direction(), preset);
        if (preset.equals((Object)ChameleonPreset.JUNK_MODE)) {
            this.plugin.getPresetDestroyer().destroyHandbrake(current.location(), current.direction());
        }
        ArrayList<FallingBlock> falls = new ArrayList<FallingBlock>();
        Material tmp = Material.BLUE_CARPET;
        for (int yy = 0; yy < 4; ++yy) {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    Block under;
                    Block b = w.getBlockAt(sbx + xx, sby + yy, sbz + zz);
                    if (yy == 0 && this.replace_with_barrier.contains((under = b.getRelative(BlockFace.DOWN)).getType())) {
                        TARDISBlockSetters.setUnderDoorBlock(w, sbx + xx, sby + yy - 1, sbz + zz, id, false);
                    }
                    if (b.getType().isAir()) continue;
                    float v = -0.5f + (float)((double)TARDISConstants.RANDOM.nextFloat() * 2.0);
                    String stainedGlass = TARDISStainedGlassLookup.stainedGlassFromMaterial(b.getWorld(), b.getType()).toString();
                    String colour = stainedGlass.replace("STAINED_GLASS", "CARPET");
                    Material carpet = Material.valueOf((String)colour);
                    if (yy == 1 && xx == 0 && zz == 0) {
                        tmp = carpet;
                    }
                    FallingBlock fb = (FallingBlock)w.spawn(b.getLocation(), FallingBlock.class, fallingBlock -> fallingBlock.setBlockData(carpet.createBlockData()));
                    falls.add(fb);
                    fb.setDropItem(false);
                    fb.setVelocity(new Vector(v, v, v));
                    b.setBlockData(TARDISConstants.AIR);
                }
            }
        }
        BlockData carpetBlockData = tmp.createBlockData();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> falls.forEach(f -> {
            f.getLocation().getBlock().setBlockData(TARDISConstants.AIR);
            f.remove();
        }), 10L);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            for (int xx = 0; xx < 3; ++xx) {
                for (int zz = 0; zz < 3; ++zz) {
                    Block block = w.getBlockAt(sbx + xx, sby, sbz + zz);
                    block.setBlockData(carpetBlockData);
                }
            }
        }, 15L);
        this.plugin.getTrackerKeeper().getDispersed().put(uuid, current.location());
        this.plugin.getTrackerKeeper().getDispersedTARDII().add(id);
        this.plugin.getPM().callEvent((Event)new TARDISHADSEvent(hostile, id, current.location(), HADS.DISPERSAL));
    }

    private List<Material> buildList() {
        ArrayList<Material> list = new ArrayList<Material>();
        this.plugin.getBlocksConfig().getStringList("under_door_blocks").forEach(str -> list.add(Material.valueOf((String)str)));
        return list;
    }
}

