/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.companionGUI;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.companionGUI.VanishChecker;
import me.eccentric_nz.TARDIS.custommodels.GUICompanion;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisCompanions;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class TARDISCompanionAddInventory
implements InventoryHolder {
    private final Player player;
    private final TARDIS plugin;
    private final UUID uuid;
    private final Inventory inventory;

    public TARDISCompanionAddInventory(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.uuid = this.player.getUniqueId();
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Add Companion", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] heads = new ItemStack[54];
        ResultSetTardisCompanions rs = new ResultSetTardisCompanions(this.plugin);
        List<Object> comps = rs.fromUUID(this.uuid.toString()) && rs.getCompanions() != null && !rs.getCompanions().isEmpty() ? List.of(rs.getCompanions().split(":")) : new ArrayList();
        int i = 0;
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            UUID puid;
            if (i >= 45 || (puid = p.getUniqueId()) == this.uuid || comps.contains(puid.toString()) || !VanishChecker.canSee(this.player, p)) continue;
            ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD, (int)1);
            SkullMeta skull = (SkullMeta)head.getItemMeta();
            skull.setOwningPlayer((OfflinePlayer)p);
            skull.displayName((Component)Component.text((String)p.getName()));
            skull.lore(List.of(Component.text((String)p.getUniqueId().toString())));
            head.setItemMeta((ItemMeta)skull);
            heads[i] = head;
            ++i;
        }
        ItemStack info = ItemStack.of((Material)GUICompanion.INFO.material(), (int)1);
        ItemMeta ii = info.getItemMeta();
        ii.displayName((Component)Component.text((String)"Info"));
        ii.lore(List.of(Component.text((String)"Click a player head to"), Component.text((String)"add them as a companion.")));
        info.setItemMeta(ii);
        heads[GUICompanion.INFO.slot()] = info;
        ItemStack list = ItemStack.of((Material)GUICompanion.LIST_COMPANIONS.material(), (int)1);
        ItemMeta ll = list.getItemMeta();
        ll.displayName((Component)Component.text((String)"List companions"));
        list.setItemMeta(ll);
        heads[GUICompanion.LIST_COMPANIONS.slot()] = list;
        ItemStack every = ItemStack.of((Material)GUICompanion.ALL_COMPANIONS.material(), (int)1);
        ItemMeta one = every.getItemMeta();
        one.displayName((Component)Component.text((String)"Add all online players"));
        every.setItemMeta(one);
        heads[GUICompanion.ALL_COMPANIONS.slot()] = every;
        ItemStack close = ItemStack.of((Material)GUICompanion.BUTTON_CLOSE.material(), (int)1);
        ItemMeta can = close.getItemMeta();
        can.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(can);
        heads[GUICompanion.BUTTON_CLOSE.slot()] = close;
        return heads;
    }
}

