/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.ARS.TARDISARSSlot;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class TARDISDisplayBlockRoomRemover
implements Runnable {
    private final TARDIS plugin;
    private final Player owner;
    private final int startx;
    private final int starty;
    private final int startz;
    private final int c = 16;
    private final int h = 16;
    private final int w = 16;
    private boolean running;
    private int level = 0;
    private int row = 0;
    private int taskId;
    private World world;
    private final BlockData blockData;

    public TARDISDisplayBlockRoomRemover(TARDIS plugin, Player owner, TARDISARSSlot slot, BlockData blockData) {
        this.plugin = plugin;
        this.owner = owner;
        this.startx = slot.getX();
        this.starty = slot.getY();
        this.startz = slot.getZ();
        this.blockData = blockData;
    }

    @Override
    public void run() {
        if (!this.running) {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", this.owner.getUniqueId().toString());
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                this.world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            }
            this.running = true;
        }
        if (this.level == 15 && this.row == 15) {
            this.plugin.getServer().getScheduler().cancelTask(this.taskId);
            this.taskId = 0;
            this.plugin.getMessenger().message((CommandSender)this.owner, "Room display item removal complete");
        } else {
            for (int col = 0; col < 16; ++col) {
                ItemDisplay display;
                int x = this.startx + this.row;
                int y = this.starty + this.level;
                int z = this.startz + col;
                Block block = this.world.getBlockAt(x, y, z);
                if (block.getType() != Material.BARRIER || (display = TARDISDisplayItemUtils.getFromBoundingBox(block)) == null) continue;
                display.remove();
                block.setBlockData(this.blockData);
            }
            if (this.row < 16) {
                ++this.row;
            }
            if (this.row == 16 && this.level < 16) {
                this.row = 0;
                ++this.level;
            }
        }
    }

    public void setTaskId(int taskId) {
        this.taskId = taskId;
    }
}

