/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners.controls;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.Rotation;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.plugin.Plugin;

public class TARDISDirectionFrameListener
implements Listener {
    private final TARDIS plugin;

    public TARDISDirectionFrameListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onDirectionFrameClick(PlayerInteractEntityEvent event) {
        Entity entity = event.getRightClicked();
        if (entity instanceof ItemFrame) {
            ItemFrame frame = (ItemFrame)entity;
            String l = frame.getLocation().toString();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("location", l);
            where.put("type", 18);
            ResultSetControls rs = new ResultSetControls(this.plugin, where, false);
            if (rs.resultSet()) {
                int id = rs.getTardis_id();
                Player player = event.getPlayer();
                HashMap<String, Object> wherep = new HashMap<String, Object>();
                wherep.put("tardis_id", id);
                ResultSetTardis rso = new ResultSetTardis(this.plugin, wherep, "", false);
                if (rso.resultSet()) {
                    ResultSetCurrentFromId rsc;
                    Tardis tardis = rso.getTardis();
                    if (!tardis.getUuid().equals(player.getUniqueId())) {
                        event.setCancelled(true);
                        return;
                    }
                    if (frame.getItem().getType().equals((Object)Material.TRIPWIRE_HOOK)) {
                        if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
                            return;
                        }
                        if (player.isSneaking()) {
                            event.setCancelled(true);
                            String direction = switch (frame.getRotation()) {
                                case Rotation.FLIPPED -> "NORTH";
                                case Rotation.FLIPPED_45 -> "NORTH_EAST";
                                case Rotation.COUNTER_CLOCKWISE -> "EAST";
                                case Rotation.COUNTER_CLOCKWISE_45 -> "SOUTH_EAST";
                                case Rotation.NONE -> "SOUTH";
                                case Rotation.CLOCKWISE_45 -> "SOUTH_WEST";
                                case Rotation.CLOCKWISE -> "WEST";
                                default -> "NORTH_WEST";
                            };
                            player.performCommand("tardis direction " + direction);
                            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, player.getName() + " issued server command: /tardis direction " + direction);
                        } else {
                            String direction;
                            Rotation r;
                            boolean isPreset = !tardis.getPreset().usesArmourStand();
                            switch (frame.getRotation()) {
                                case FLIPPED: {
                                    r = Rotation.FLIPPED_45;
                                    direction = isPreset ? "EAST" : "NORTH_EAST";
                                    break;
                                }
                                case FLIPPED_45: {
                                    r = Rotation.COUNTER_CLOCKWISE;
                                    direction = "EAST";
                                    break;
                                }
                                case COUNTER_CLOCKWISE_45: {
                                    r = Rotation.NONE;
                                    direction = "SOUTH";
                                    break;
                                }
                                case CLOCKWISE_45: {
                                    r = Rotation.CLOCKWISE;
                                    direction = "WEST";
                                    break;
                                }
                                case CLOCKWISE_135: {
                                    r = Rotation.FLIPPED;
                                    direction = "NORTH";
                                    break;
                                }
                                case COUNTER_CLOCKWISE: {
                                    r = Rotation.COUNTER_CLOCKWISE_45;
                                    direction = isPreset ? "SOUTH" : "SOUTH_EAST";
                                    break;
                                }
                                case NONE: {
                                    r = Rotation.CLOCKWISE_45;
                                    direction = isPreset ? "WEST" : "SOUTH_WEST";
                                    break;
                                }
                                default: {
                                    r = Rotation.CLOCKWISE_135;
                                    String string = direction = isPreset ? "NORTH" : "NORTH_WEST";
                                }
                            }
                            if (isPreset) {
                                frame.setRotation(r);
                            }
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DIRECTON_SET", direction);
                        }
                    } else if (frame.getItem().getType().isAir() && player.getInventory().getItemInMainHand().getType().equals((Object)Material.TRIPWIRE_HOOK) && (rsc = new ResultSetCurrentFromId(this.plugin, id)).resultSet()) {
                        Current current = rsc.getCurrent();
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            Rotation r = switch (current.direction()) {
                                case COMPASS.EAST -> Rotation.COUNTER_CLOCKWISE;
                                case COMPASS.SOUTH_EAST -> Rotation.COUNTER_CLOCKWISE_45;
                                case COMPASS.SOUTH -> Rotation.NONE;
                                case COMPASS.SOUTH_WEST -> Rotation.CLOCKWISE_45;
                                case COMPASS.WEST -> Rotation.CLOCKWISE;
                                case COMPASS.NORTH_WEST -> Rotation.CLOCKWISE_135;
                                case COMPASS.NORTH -> Rotation.FLIPPED;
                                default -> Rotation.FLIPPED_45;
                            };
                            frame.setRotation(r);
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DIRECTION_CURRENT", current.direction().toString());
                        }, 4L);
                    }
                }
            }
        }
    }
}

