/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.siegemode;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.siegemode.TARDISSiegeArea;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Ageable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.plugin.Plugin;

public class TARDISGrowthListener
implements Listener {
    private final TARDIS plugin;
    private final int chance;
    private final List<Material> plants = List.of(Material.AIR, Material.BEETROOTS, Material.CACTUS, Material.CARROTS, Material.COCOA, Material.WHEAT, Material.MELON_STEM, Material.NETHER_WART, Material.POTATOES, Material.PUMPKIN_STEM, Material.SUGAR_CANE);

    public TARDISGrowthListener(TARDIS plugin) {
        this.plugin = plugin;
        this.chance = this.plugin.getConfig().getInt("siege.growth");
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlantGrowth(BlockGrowEvent event) {
        Block plant = event.getBlock();
        Material species = plant.getType();
        if (!this.plants.contains(species)) {
            return;
        }
        Location l = plant.getLocation();
        String w = l.getWorld().getName();
        if (!this.plugin.getTrackerKeeper().getSiegeGrowthAreas().containsKey(w)) {
            return;
        }
        for (TARDISSiegeArea area : this.plugin.getTrackerKeeper().getSiegeGrowthAreas().get(w)) {
            if (!area.isInSiegeArea(l) || TARDISConstants.RANDOM.nextInt(100) >= this.chance) continue;
            if (species.isAir()) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> plant.getRelative(BlockFace.UP).setBlockData(plant.getRelative(BlockFace.DOWN).getType().createBlockData()), 3L);
                break;
            }
            if (!(plant instanceof Ageable)) break;
            Ageable ageable = (Ageable)plant;
            int age = ageable.getAge();
            switch (species) {
                case CACTUS: 
                case SUGAR_CANE: {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> plant.getRelative(BlockFace.UP).setBlockData(plant.getRelative(BlockFace.DOWN).getType().createBlockData()), 3L);
                    break;
                }
                case BEETROOTS: 
                case CARROTS: 
                case WHEAT: 
                case MELON_STEM: 
                case POTATOES: 
                case PUMPKIN_STEM: {
                    if (age >= 6) break;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ageable.setAge(age + 2), 3L);
                    break;
                }
                case COCOA: {
                    if (age >= 4 || TARDISConstants.RANDOM.nextInt(100) >= 25) break;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ageable.setAge(age + 8), 3L);
                    break;
                }
                case NETHER_WART: {
                    if (age >= 2 || TARDISConstants.RANDOM.nextInt(100) >= 33) break;
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ageable.setAge(age + 2), 3L);
                    break;
                }
            }
            break;
        }
    }
}

