/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.control.TARDISScanner;
import me.eccentric_nz.TARDIS.lazarus.disguise.AGE;
import me.eccentric_nz.TARDIS.lazarus.disguise.FOX;
import me.eccentric_nz.TARDIS.lazarus.disguise.GENE;
import me.eccentric_nz.TARDIS.lazarus.disguise.MUSHROOM_COW;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Cat;
import org.bukkit.entity.ChestedHorse;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Pig;
import org.bukkit.entity.PufferFish;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Snowman;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;
import org.bukkit.entity.Wolf;
import org.bukkit.entity.ZombieVillager;

public class TARDISEntityTracker {
    private final TARDIS plugin;

    public TARDISEntityTracker(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addNPCs(Location exterior, Location interior, UUID uuid) {
        List<Entity> ents = TARDISScanner.getNearbyEntities(exterior, 6);
        ArrayList<UUID> npcids = new ArrayList<UUID>();
        for (Entity e : ents) {
            if (!(e instanceof LivingEntity)) continue;
            Location location = e.getLocation();
            double relx = location.getX() - exterior.getX();
            double rely = location.getY() - exterior.getY();
            double relz = location.getZ() - exterior.getZ();
            double adjx = interior.getX() + relx;
            double adjy = interior.getY() + rely;
            double adjz = interior.getZ() + relz;
            Location l = new Location(interior.getWorld(), adjx, adjy, adjz);
            l.setYaw(location.getYaw());
            l.setPitch(location.getPitch());
            this.plugin.setTardisSpawn(true);
            ArmorStand stand = (ArmorStand)interior.getWorld().spawnEntity(l, EntityType.ARMOR_STAND);
            npcids.add(stand.getUniqueId());
            Object[] options = null;
            switch (e.getType()) {
                case CAT: {
                    options = new Object[]{((Cat)e).getCatType(), ((Tameable)e).isTamed(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case PANDA: {
                    options = new Object[]{GENE.getFromPandaGene(((Panda)e).getMainGene()), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case DONKEY: 
                case MULE: {
                    options = new Object[]{((ChestedHorse)e).isCarryingChest(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case PIG: {
                    options = new Object[]{((Pig)e).hasSaddle(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case CREEPER: {
                    options = new Object[]{((Creeper)e).isPowered()};
                    break;
                }
                case ENDERMAN: {
                    options = new Object[]{((Enderman)e).getCarriedBlock() != null};
                    break;
                }
                case SHEEP: {
                    options = new Object[]{((Sheep)e).getColor(), ((Tameable)e).isTamed(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case WOLF: {
                    options = new Object[]{((Wolf)e).getCollarColor(), ((Tameable)e).isTamed(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case HORSE: {
                    options = new Object[]{((Horse)e).getColor(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case LLAMA: {
                    options = new Object[]{((Llama)e).getColor(), ((Llama)e).getInventory().getDecor() != null, AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case OCELOT: {
                    options = new Object[]{((Tameable)e).isTamed(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case PARROT: {
                    options = new Object[]{((Parrot)e).getVariant(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case RABBIT: {
                    options = new Object[]{((Rabbit)e).getRabbitType(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case VILLAGER: {
                    options = new Object[]{((Villager)e).getProfession(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case ZOMBIE_VILLAGER: {
                    options = new Object[]{((ZombieVillager)e).getVillagerProfession(), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case SLIME: 
                case MAGMA_CUBE: {
                    options = new Object[]{((Slime)e).getSize()};
                    break;
                }
                case COW: 
                case TURTLE: 
                case ZOMBIE: 
                case BEE: {
                    options = new Object[]{AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case SNOW_GOLEM: {
                    options = new Object[]{((Snowman)e).isDerp()};
                    break;
                }
                case PUFFERFISH: {
                    options = new Object[]{((PufferFish)e).getPuffState()};
                    break;
                }
                case TROPICAL_FISH: {
                    options = new Object[]{((TropicalFish)e).getPattern()};
                    break;
                }
                case MOOSHROOM: {
                    options = new Object[]{MUSHROOM_COW.getFromMushroomCowType(((MushroomCow)e).getVariant()), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
                case FOX: {
                    options = new Object[]{FOX.getFromFoxType(((Fox)e).getFoxType()), AGE.getFromBoolean(!((Ageable)e).isAdult())};
                    break;
                }
            }
            this.plugin.getTardisHelper().disguiseArmourStand(stand, e.getType(), options);
        }
        if (!npcids.isEmpty()) {
            this.plugin.getTrackerKeeper().getRenderedNPCs().put(uuid, npcids);
        }
    }

    public void removeNPCs(UUID uuid) {
        this.plugin.getTrackerKeeper().getRenderedNPCs().get(uuid).forEach(i -> {
            Entity npc = Bukkit.getEntity((UUID)i);
            if (npc != null) {
                this.plugin.getTardisHelper().undisguiseArmourStand((ArmorStand)npc);
                npc.remove();
            }
        });
        this.plugin.getTrackerKeeper().getRenderedNPCs().remove(uuid);
    }
}

