/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.populators;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.List;
import java.util.Random;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.IslandSpiral;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.SkaroStructureUtility;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.TARDISLootTables;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.WaterCircle;
import me.eccentric_nz.tardisweepingangels.monsters.daleks.DalekEquipment;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.BlockVector;

public class SkaroStructurePopulator
extends BlockPopulator {
    private final TARDIS plugin;
    private final List<EntityType> animals = List.of(EntityType.SHEEP, EntityType.COW, EntityType.PIG, EntityType.CHICKEN, EntityType.HORSE, EntityType.GOAT);

    public SkaroStructurePopulator(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void populate(WorldInfo worldInfo, Random random, int x, int z, LimitedRegion limitedRegion) {
        block12: {
            int zz;
            int y;
            int xx;
            block13: {
                if (!this.isFeatureChunk(worldInfo.getSeed(), x, z)) break block12;
                xx = x * 16;
                y = 128;
                zz = z * 16;
                for (int i = 128; i > 60 && !limitedRegion.getType(xx, y, zz).equals((Object)Material.SAND) && !limitedRegion.getType(xx, y, zz).equals((Object)Material.WATER); --i) {
                    --y;
                }
                if (!limitedRegion.isInRegion(xx, y, zz)) break block12;
                if (!limitedRegion.getType(xx, y - 1, zz).equals((Object)Material.WATER)) break block13;
                IslandSpiral spiral = new IslandSpiral();
                double[][] island = spiral.createMatrix(16, 16, random, 0.01);
                boolean[][] blob = WaterCircle.makeBlob();
                for (int r = 1; r < 15; ++r) {
                    for (int c = 1; c < 15; ++c) {
                        if (!blob[r][c]) continue;
                        double n = island[r][c];
                        int top = n > 0.0 ? (int)(n * 6.0) : 0;
                        int bottom = -6 - (int)(n * 40.0);
                        for (int h = top; h >= bottom; --h) {
                            int wx = xx + r;
                            int wy = y + h;
                            int wz = zz + c;
                            if (!limitedRegion.isInRegion(wx, wy, wz)) continue;
                            Material material = h > top - 3 ? Material.SAND : Material.SANDSTONE;
                            limitedRegion.setType(wx, wy, wz, material);
                        }
                    }
                }
                this.build(limitedRegion, xx + 2, y + 2, zz + 3, random, "small");
                if (!this.plugin.getConfig().getBoolean("modules.weeping_angels")) break block12;
                for (int i = 0; i < random.nextInt(3) + 1; ++i) {
                    LivingEntity le = (LivingEntity)limitedRegion.spawnEntity(new Location(null, (double)(xx + 8), (double)(y + 3), (double)(zz + 8)), EntityType.SKELETON);
                    if (!this.plugin.getConfig().getBoolean("modules.weeping_angels")) continue;
                    DalekEquipment.set(le, false);
                }
                break block12;
            }
            this.build(limitedRegion, xx, y, zz, random, "large");
            if (limitedRegion.getBuffer() > 15) {
                int dir = random.nextInt(4);
                List<BlockVector> grid = switch (dir) {
                    case 0 -> SkaroStructureUtility.vectorLeft;
                    case 1 -> SkaroStructureUtility.vectorUp;
                    case 2 -> SkaroStructureUtility.vectorRight;
                    default -> SkaroStructureUtility.vectorDown;
                };
                int i = 0;
                for (BlockVector vector : grid) {
                    this.build(limitedRegion, xx + vector.getBlockX(), i == 0 ? y : -99, zz + vector.getBlockZ(), random, SkaroStructureUtility.structures.get(i));
                    ++i;
                }
            }
        }
    }

    public boolean isFeatureChunk(long seed, int x, int z) {
        RandomSpreadStructurePlacement spread = new RandomSpreadStructurePlacement(24, 8, RandomSpreadType.TRIANGULAR, 165745295);
        ChunkPos chunkPos = spread.getPotentialStructureChunk(seed, x, z);
        return chunkPos.x == x && chunkPos.z == z;
    }

    private void build(LimitedRegion limitedRegion, int startX, int startY, int startZ, Random random, String which) {
        String path = "schematics/dalek_" + which + ".tschm";
        InputStream stream = this.plugin.getResource(path);
        if (stream != null) {
            JsonObject obj = TARDISSchematicGZip.unzip(stream);
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            int h = dimensions.get("height").getAsInt() - 1;
            int w = dimensions.get("width").getAsInt();
            int d = dimensions.get("length").getAsInt() - 1;
            int level = 0;
            int row = 0;
            if (startY == -99) {
                startY = 129;
                for (int i = 128; i > 60 && !limitedRegion.getType(startX, startY, startZ).equals((Object)Material.SAND) && !limitedRegion.getType(startX, startY, startZ).equals((Object)Material.WATER); --i) {
                    --startY;
                }
                ++startY;
            }
            JsonArray arr = obj.get("input").getAsJsonArray();
            while (level <= h && row < w) {
                JsonArray floor = arr.get(level).getAsJsonArray();
                JsonArray r = floor.get(row).getAsJsonArray();
                for (int col = 0; col <= d; ++col) {
                    JsonObject c = r.get(col).getAsJsonObject();
                    int x = startX + row;
                    int y = startY + level;
                    int z = startZ + col;
                    BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                    Material type = data.getMaterial();
                    if (limitedRegion.isInRegion(x, y, z)) {
                        switch (type) {
                            case CHEST: {
                                limitedRegion.setBlockData(x, y, z, data);
                                if (!limitedRegion.getType(x, y, z).equals((Object)Material.CHEST)) break;
                                Chest container = (Chest)limitedRegion.getBlockState(x, y, z);
                                container.setLootTable(TARDISLootTables.LOOT.get(random.nextInt(11)));
                                container.update();
                                break;
                            }
                            case SPONGE: {
                                if (limitedRegion.getType(x, y, z).isOccluding()) break;
                                limitedRegion.setType(x, y, z, Material.AIR);
                                break;
                            }
                            case SPAWNER: {
                                limitedRegion.setBlockData(x, y, z, data);
                                CreatureSpawner cs = (CreatureSpawner)limitedRegion.getBlockState(x, y, z);
                                cs.setSpawnedType(EntityType.SKELETON);
                                cs.update();
                                break;
                            }
                            case SOUL_SAND: {
                                limitedRegion.setType(x, y, z, Material.GRASS_BLOCK);
                                EntityType entityType = this.animals.get(random.nextInt(this.animals.size()));
                                for (int i = 0; i < random.nextInt(3) + 1; ++i) {
                                    LivingEntity le = (LivingEntity)limitedRegion.spawnEntity(new Location(null, (double)x, (double)(y + 1), (double)z), entityType);
                                    le.setRemoveWhenFarAway(false);
                                    le.setPersistent(true);
                                    if (i <= 0) continue;
                                    ((Ageable)le).setBaby();
                                }
                                break;
                            }
                            default: {
                                limitedRegion.setBlockData(x, y, z, data);
                                if (level != 0) break;
                                int yy = y - 1;
                                while (limitedRegion.getType(x, yy, z).isAir() || limitedRegion.getType(x, yy, z).equals((Object)Material.WATER)) {
                                    limitedRegion.setType(x, yy, z, Material.SAND);
                                    --yy;
                                }
                                break block0;
                            }
                        }
                    }
                    if (col == d && row < w) {
                        ++row;
                    }
                    if (col != d || row != w || level >= h) continue;
                    row = 0;
                    ++level;
                }
            }
        }
    }
}

