/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISAdvancedConsoleInventory;
import me.eccentric_nz.TARDIS.advanced.TARDISAuthorisedControlDisk;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPowered;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISConsoleListener
implements Listener {
    private final TARDIS plugin;
    private final List<Material> onlythese = new ArrayList<Material>();

    public TARDISConsoleListener(TARDIS plugin) {
        this.plugin = plugin;
        for (DiskCircuit dc : DiskCircuit.values()) {
            if (this.onlythese.contains(dc.getMaterial())) continue;
            this.onlythese.add(dc.getMaterial());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onConsoleInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player p = event.getPlayer();
        UUID uuid = p.getUniqueId();
        if (!TARDISPermission.hasPermission(p, "tardis.advanced")) {
            return;
        }
        if (this.plugin.getTrackerKeeper().getUpdatePlayers().containsKey(uuid)) {
            return;
        }
        if (!event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK)) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null || !block.getType().equals((Object)Material.JUKEBOX) && !block.getType().equals((Object)Material.MUSHROOM_STEM) && !block.getType().equals((Object)Material.BARRIER)) {
            return;
        }
        HashMap<String, Object> wherec = new HashMap<String, Object>();
        wherec.put("location", block.getLocation().toString());
        wherec.put("type", 15);
        ResultSetControls rsc = new ResultSetControls(this.plugin, wherec, false);
        if (!rsc.resultSet()) {
            return;
        }
        event.setCancelled(true);
        if (!(TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(p.getUniqueId()) || !block.getType().equals((Object)Material.JUKEBOX) && !block.getType().equals((Object)Material.MUSHROOM_STEM))) {
            block.setType(Material.BARRIER);
            TARDISDisplayItemUtils.set(TARDISDisplayItem.ADVANCED_CONSOLE, block, rsc.getTardis_id());
        }
        int id = rsc.getTardis_id();
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
        String key = rsp.resultSet() ? (!rsp.getKey().isEmpty() ? rsp.getKey() : this.plugin.getConfig().getString("preferences.key")) : this.plugin.getConfig().getString("preferences.key");
        this.onlythese.add(Material.valueOf((String)key));
        ItemStack disk = event.getPlayer().getInventory().getItemInMainHand();
        if (this.onlythese.contains(disk.getType()) && disk.hasItemMeta() || key.equals("AIR")) {
            ResultSetTardisPowered rs = new ResultSetTardisPowered(this.plugin);
            if (!rs.fromBoth(id, uuid.toString())) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "NOT_OWNER");
                return;
            }
            if (this.plugin.getConfig().getBoolean("allow.power_down") && !rs.isPowered()) {
                this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "POWER_DOWN");
                return;
            }
            p.openInventory(new TARDISAdvancedConsoleInventory(this.plugin, uuid.toString(), id).getInventory());
        } else if (disk.getType().equals((Object)Material.MUSIC_DISC_FAR)) {
            ItemMeta im = disk.getItemMeta();
            if (im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Authorised Control Disk") && im.getPersistentDataContainer().has(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID())) {
                UUID diskUuid = (UUID)im.getPersistentDataContainer().get(this.plugin.getTimeLordUuidKey(), this.plugin.getPersistentDataTypeUUID());
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                ResultSetTardis rst = new ResultSetTardis(this.plugin, where, "", false);
                if (rst.resultSet() && rst.getTardis().getUuid().equals(diskUuid)) {
                    if (uuid == rst.getTardis().getUuid()) {
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SECURITY_TIMELORD");
                        return;
                    }
                    Tardis tardis = rst.getTardis();
                    TARDISAuthorisedControlDisk tacd = new TARDISAuthorisedControlDisk(this.plugin, tardis.getUuid(), im.lore(), id, p, tardis.getEps(), tardis.getCreeper());
                    String processed = tacd.process();
                    if (processed.equals("success")) {
                        int amount = p.getInventory().getItemInMainHand().getAmount();
                        int adjusted = amount - 1;
                        if (adjusted > 0) {
                            p.getInventory().getItemInMainHand().setAmount(adjusted);
                        } else {
                            p.getInventory().setItemInMainHand(null);
                        }
                        p.updateInventory();
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SECURITY_SUCCESS");
                    } else {
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SECURITY_ERROR", processed);
                    }
                }
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ADV_OPEN");
        }
    }
}

