/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISInstantPoliceBox;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISInstantPreset;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISEmergencyRelocation {
    private final TARDIS plugin;

    public TARDISEmergencyRelocation(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void relocate(int id, Player p) {
        World w;
        Location emergency;
        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "EMERGENCY");
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet() && (emergency = new TARDISTimeTravel(this.plugin).randomDestination(p, 4, 4, 4, COMPASS.EAST, "THIS", w = (World)this.plugin.getServer().getWorlds().getFirst(), false, w.getSpawnLocation())) != null) {
            BuildData bd = new BuildData(p.getUniqueId().toString());
            bd.setPlayer((OfflinePlayer)p);
            bd.setLocation(emergency);
            bd.setTardisID(id);
            bd.setDirection(COMPASS.EAST);
            bd.setMalfunction(false);
            bd.setSubmarine(false);
            bd.setThrottle(SpaceTimeThrottle.REBUILD);
            Tardis tardis = rs.getTardis();
            if (tardis.getPreset().usesArmourStand()) {
                new TARDISInstantPoliceBox(this.plugin, bd, tardis.getPreset()).buildPreset();
            } else {
                new TARDISInstantPreset(this.plugin, bd, tardis.getPreset(), Material.LIGHT_GRAY_TERRACOTTA.createBlockData(), false).buildPreset();
            }
            HashMap<String, Object> wherec = new HashMap<String, Object>();
            wherec.put("tardis_id", id);
            HashMap<String, Object> setc = new HashMap<String, Object>();
            setc.put("world", emergency.getWorld().getName());
            setc.put("x", emergency.getBlockX());
            setc.put("y", emergency.getBlockY());
            setc.put("z", emergency.getBlockZ());
            setc.put("direction", "EAST");
            setc.put("submarine", 0);
            this.plugin.getQueryFactory().doUpdate("current", setc, wherec);
            HashMap<String, Object> whereb = new HashMap<String, Object>();
            whereb.put("tardis_id", id);
            HashMap<String, Object> setb = new HashMap<String, Object>();
            setb.put("world", emergency.getWorld().getName());
            setb.put("x", emergency.getBlockX());
            setb.put("y", emergency.getBlockY());
            setb.put("z", emergency.getBlockZ());
            setb.put("direction", "EAST");
            setb.put("submarine", 0);
            this.plugin.getQueryFactory().doUpdate("current", setb, whereb);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "EMERGENCY_DONE");
            HashMap<String, Object> wherea = new HashMap<String, Object>();
            wherea.put("tardis_id", id);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -this.plugin.getArtronConfig().getInt("travel"), wherea, p);
        }
    }
}

