/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.utility;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISCondenserData;
import me.eccentric_nz.TARDIS.rooms.TARDISRoomBuilder;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISZeroRoomBuilder {
    private final TARDIS plugin;

    public TARDISZeroRoomBuilder(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean build(Player p, int tips, int id) {
        if (!this.plugin.getConfig().getBoolean("allow.zero_room")) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ZERO_DISABLED");
            return true;
        }
        TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
        int slot = tips;
        if (tips == -1) {
            slot = tintpos.getFreeSlot();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tips", slot);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            this.plugin.getQueryFactory().doUpdate("tardis", set, where);
        }
        TARDISTIPSData pos = tintpos.getTIPSData(slot);
        int x = pos.getCentreX();
        int y = 64;
        int z = pos.getCentreZ();
        World w = this.plugin.getServer().getWorld("TARDIS_Zero_room");
        if (w == null) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ZERO_NOT_FOUND");
            return true;
        }
        Location l = new Location(w, (double)x, (double)y, (double)z);
        TARDISRoomBuilder builder = new TARDISRoomBuilder(this.plugin, "ZERO", l, COMPASS.SOUTH, p);
        if (builder.build()) {
            UUID uuid = p.getUniqueId();
            int amount = this.plugin.getRoomsConfig().getInt("rooms.ZERO.cost");
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("uuid", p.getUniqueId().toString());
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, set, p);
            if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks")) {
                TARDISCondenserData c_data = this.plugin.getGeneralKeeper().getRoomCondenserData().get(uuid);
                c_data.getBlockIDCount().forEach((key, value) -> {
                    HashMap<String, Object> wherec = new HashMap<String, Object>();
                    wherec.put("tardis_id", c_data.getTardis_id());
                    wherec.put("block_data", key);
                    this.plugin.getQueryFactory().alterCondenserBlockCount((int)value, wherec);
                });
                this.plugin.getGeneralKeeper().getRoomCondenserData().remove(uuid);
            }
            if (this.plugin.getAchievementConfig().getBoolean("rooms.enabled")) {
                TARDISAchievementFactory taf = new TARDISAchievementFactory(this.plugin, p, Advancement.ROOMS, this.plugin.getBuildKeeper().getSeeds().size());
                taf.doAchievement("ZERO");
            }
        }
        return true;
    }
}

