/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TARDISTIPSData;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCondenser;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.TARDISDelavafier;
import me.eccentric_nz.TARDIS.desktop.TARDISThemeRepairRunnable;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISCondenserData;
import me.eccentric_nz.TARDIS.schematic.ArchiveUpdate;
import me.eccentric_nz.TARDIS.schematic.ResultSetArchive;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISRepair {
    private final TARDIS plugin;
    private final Player player;

    public TARDISRepair(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    public void restore(boolean clean) {
        UUID uuid = this.player.getUniqueId();
        TARDISUpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(uuid);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            boolean hasLava;
            Tardis tardis = rs.getTardis();
            String perm = tardis.getSchematic().getPermission();
            boolean bl = hasLava = tud.getPrevious().getPermission().equals("master") || tud.getPrevious().getPermission().equals("delta");
            if (hasLava) {
                new TARDISDelavafier(this.plugin, uuid).swap();
            }
            String wall = "ORANGE_WOOL";
            String floor = "LIGHT_GRAY_WOOL";
            if (perm.equals("archive")) {
                new ArchiveUpdate(this.plugin, uuid.toString(), this.getArchiveName()).setInUse();
                tud.setSchematic(Consoles.schematicFor("archive"));
            } else {
                tud.setSchematic(tud.getPrevious());
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                if (rsp.resultSet()) {
                    wall = rsp.getWall();
                    floor = rsp.getFloor();
                }
            }
            tud.setWall(wall);
            tud.setFloor(floor);
            this.plugin.getTrackerKeeper().getUpgrades().put(uuid, tud);
            TARDISThemeRepairRunnable ttr = new TARDISThemeRepairRunnable(this.plugin, uuid, tud, clean);
            long initial_delay = hasLava ? 45L : 5L;
            long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)ttr, initial_delay, delay);
            ttr.setTaskID(task);
        }
    }

    boolean hasCondensedMissingBlocks() {
        UUID uuid = this.player.getUniqueId();
        HashMap<String, Integer> blockIDs = new HashMap<String, Integer>();
        JsonObject obj = this.getConsole();
        if (obj.has("dimensions")) {
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            int h = dimensions.get("height").getAsInt();
            int w = dimensions.get("width").getAsInt();
            int l = dimensions.get("length").getAsInt();
            JsonArray arr = obj.get("input").getAsJsonArray();
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                int startz;
                int startx;
                Tardis tardis = rs.getTardis();
                int slot = tardis.getTIPS();
                int id = tardis.getTardisId();
                if (slot != -1000001) {
                    TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                    TARDISTIPSData pos = tintpos.getTIPSData(slot);
                    startx = pos.getCentreX();
                    startz = pos.getCentreZ();
                } else {
                    int[] gsl = this.plugin.getLocationUtils().getStartLocation(tardis.getTardisId());
                    startx = gsl[0];
                    startz = gsl[2];
                }
                int starty = tardis.getSchematic().getStartY();
                World world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
                String wall = "ORANGE_WOOL";
                String floor = "LIGHT_GRAY_WOOL";
                Material wall_type = Material.ORANGE_WOOL;
                Material floor_type = Material.LIGHT_GRAY_WOOL;
                boolean hasPrefs = false;
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                if (rsp.resultSet()) {
                    hasPrefs = true;
                    wall_type = Material.getMaterial((String)rsp.getWall());
                    floor_type = Material.getMaterial((String)rsp.getFloor());
                }
                for (int level = 0; level < h; ++level) {
                    JsonArray plane = arr.get(level).getAsJsonArray();
                    for (int row = 0; row < w; ++row) {
                        JsonArray r = (JsonArray)plane.get(row);
                        for (int i = 0; i < l; ++i) {
                            Integer count;
                            int x = startx + row;
                            int y = starty + level;
                            int z = startz + i;
                            JsonObject c = r.get(i).getAsJsonObject();
                            BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                            String bid = data.getMaterial().toString();
                            if (this.plugin.getBuildKeeper().getIgnoreBlocks().contains(bid)) continue;
                            if (this.plugin.getBuildKeeper().getBlockConversion().containsKey(bid)) {
                                if (world.getBlockAt(x, y, z).getType().toString().equals(bid)) continue;
                                bid = this.plugin.getBuildKeeper().getBlockConversion().get(bid);
                            }
                            if (bid.equals("ORANGE_WOOL")) {
                                if (world.getBlockAt(x, y, z).getType().equals((Object)wall_type)) continue;
                                if (blockIDs.containsKey(bid)) {
                                    count = (Integer)blockIDs.get(bid) + 1;
                                    blockIDs.put(bid, count);
                                    continue;
                                }
                                blockIDs.put(bid, 1);
                                continue;
                            }
                            if (bid.equals("LIGHT_GRAY_WOOL")) {
                                if (world.getBlockAt(x, y, z).getType().equals((Object)floor_type)) continue;
                                if (blockIDs.containsKey(bid)) {
                                    count = (Integer)blockIDs.get(bid) + 1;
                                    blockIDs.put(bid, count);
                                    continue;
                                }
                                blockIDs.put(bid, 1);
                                continue;
                            }
                            if (world.getBlockAt(x, y, z).getType().toString().equals(bid)) continue;
                            if (blockIDs.containsKey(bid)) {
                                count = (Integer)blockIDs.get(bid) + 1;
                                blockIDs.put(bid, count);
                                continue;
                            }
                            blockIDs.put(bid, 1);
                        }
                    }
                }
                HashMap<String, Integer> blockTypeCount = new HashMap<String, Integer>();
                boolean hasRequired = true;
                HashMap<String, Integer> item_counts = new HashMap<String, Integer>();
                for (Map.Entry entry : blockIDs.entrySet()) {
                    String block_id;
                    String bkey;
                    String bid = (String)entry.getKey();
                    if (hasPrefs && (((String)entry.getKey()).equals("ORANGE_WOOL") || ((String)entry.getKey()).equals("LIGHT_GRAY_WOOL"))) {
                        bkey = ((String)entry.getKey()).equals("ORANGE_WOOL") ? wall : floor;
                        block_id = ((String)entry.getKey()).equals("ORANGE_WOOL") ? wall : floor;
                    } else {
                        bkey = bid;
                        block_id = bid;
                    }
                    if (blockTypeCount.containsKey(bkey)) {
                        blockTypeCount.put(bkey, blockTypeCount.get(bkey) + (Integer)entry.getValue());
                    } else {
                        blockTypeCount.put(bkey, (Integer)entry.getValue());
                    }
                    if (item_counts.containsKey(block_id)) {
                        item_counts.put(block_id, (Integer)item_counts.get(block_id) + (Integer)entry.getValue());
                        continue;
                    }
                    item_counts.put(block_id, (Integer)entry.getValue());
                }
                for (Map.Entry entry : item_counts.entrySet()) {
                    HashMap<String, Object> wherec = new HashMap<String, Object>();
                    wherec.put("tardis_id", id);
                    wherec.put("block_data", entry.getKey());
                    ResultSetCondenser rsc = new ResultSetCondenser(this.plugin, wherec);
                    if (rsc.resultSet()) {
                        if (rsc.getBlock_count() >= (Integer)entry.getValue()) continue;
                        hasRequired = false;
                        int diff = (Integer)entry.getValue() - rsc.getBlock_count();
                        this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "CONDENSE_MORE", String.format("%d", diff), Material.getMaterial((String)((String)entry.getKey())).toString());
                        continue;
                    }
                    hasRequired = false;
                    this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "CONDENSE_MIN", String.format("%d", entry.getValue()), Material.getMaterial((String)((String)entry.getKey())).toString());
                }
                if (!hasRequired) {
                    this.player.sendMessage("-----------------------------");
                    return false;
                }
                TARDISCondenserData c_data = new TARDISCondenserData();
                c_data.setBlockIDCount(blockTypeCount);
                c_data.setTardis_id(id);
                this.plugin.getGeneralKeeper().getRoomCondenserData().put(this.player.getUniqueId(), c_data);
                return true;
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "REPAIR_FAIL", "No JSON data");
        }
        return false;
    }

    private JsonObject getConsole() {
        JsonObject obj = new JsonObject();
        UUID uuid = this.player.getUniqueId();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            String perm = tardis.getSchematic().getPermission();
            if (perm.equals("archive")) {
                HashMap<String, Object> wherea = new HashMap<String, Object>();
                wherea.put("uuid", uuid);
                wherea.put("use", 1);
                ResultSetArchive rsa = new ResultSetArchive(this.plugin, wherea);
                if (rsa.resultSet()) {
                    obj = rsa.getArchive().getJSON();
                } else {
                    HashMap<String, Object> wherea2 = new HashMap<String, Object>();
                    wherea2.put("uuid", uuid);
                    wherea2.put("use", 2);
                    ResultSetArchive rsa2 = new ResultSetArchive(this.plugin, wherea2);
                    if (rsa2.resultSet()) {
                        obj = rsa2.getArchive().getJSON();
                        new ArchiveUpdate(this.plugin, uuid.toString(), rsa2.getArchive().getName()).setInUse();
                    } else {
                        HashMap<String, Object> wherea3 = new HashMap<String, Object>();
                        wherea3.put("uuid", uuid);
                        wherea3.put("use", 0);
                        ResultSetArchive rsa3 = new ResultSetArchive(this.plugin, wherea3);
                        if (rsa3.resultSet()) {
                            obj = rsa2.getArchive().getJSON();
                            new ArchiveUpdate(this.plugin, uuid.toString(), rsa3.getArchive().getName()).setInUse();
                        }
                    }
                }
            } else {
                obj = TARDISSchematicGZip.getObject(this.plugin, "consoles", tardis.getSchematic().getPermission(), tardis.getSchematic().isCustom());
            }
        }
        return obj;
    }

    private String getArchiveName() {
        String uuid = this.player.getUniqueId().toString();
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("uuid", uuid);
        wherea.put("use", 1);
        ResultSetArchive rsa = new ResultSetArchive(this.plugin, wherea);
        if (rsa.resultSet()) {
            return rsa.getArchive().getName();
        }
        HashMap<String, Object> wherea2 = new HashMap<String, Object>();
        wherea2.put("uuid", uuid);
        wherea2.put("use", 2);
        ResultSetArchive rsa2 = new ResultSetArchive(this.plugin, wherea2);
        if (rsa2.resultSet()) {
            return rsa2.getArchive().getName();
        }
        HashMap<String, Object> wherea3 = new HashMap<String, Object>();
        wherea3.put("uuid", uuid);
        wherea3.put("use", 0);
        ResultSetArchive rsa3 = new ResultSetArchive(this.plugin, wherea3);
        if (rsa3.resultSet()) {
            return rsa3.getArchive().getName();
        }
        return "";
    }
}

