/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitDamager;
import me.eccentric_nz.TARDIS.custommodels.GUITemporalLocator;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateTemporalForm {
    private final TARDIS plugin;
    private final UUID uuid;

    public FloodgateTemporalForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("Temporal Locator");
        for (GUITemporalLocator clock : GUITemporalLocator.values()) {
            builder.button(clock.getName() + " ~" + clock.getLore(), FormImage.Type.PATH, "textures/items/clock_item.png");
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        String label = response.clickedButton().text();
        long ticks = this.getTime(label);
        this.plugin.getTrackerKeeper().getSetTime().put(player.getUniqueId(), ticks);
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TEMPORAL_SET", String.format("%d", ticks));
        if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.temporal") > 0) {
            int id = this.plugin.getTardisAPI().getIdOfTARDISPlayerIsIn(player.getUniqueId());
            TARDISCircuitChecker tcc = new TARDISCircuitChecker(this.plugin, id);
            tcc.getCircuits();
            int uses_left = tcc.getTemporalUses();
            new TARDISCircuitDamager(this.plugin, DiskCircuit.TEMPORAL, uses_left, id, player).damage();
        }
    }

    private long getTime(String label) {
        String[] data = label.split("~");
        return TARDISNumberParsers.parseLong(data[1]);
    }
}

