/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import me.libraryaddict.disguise.disguisetypes.PlayerDisguise;
import me.libraryaddict.disguise.disguisetypes.watchers.AgeableWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AllayWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.AxolotlWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.BlazeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ChestedHorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.CreeperWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.EndermanWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FoxWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.FrogWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.GoatWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.HorseWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LivingWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.LlamaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.MushroomCowWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.OcelotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PandaWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ParrotWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PigWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.PufferFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.RabbitWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SheepWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SlimeWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.SnowmanWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TropicalFishWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.TurtleWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.VillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WardenWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.WolfWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieVillagerWatcher;
import me.libraryaddict.disguise.disguisetypes.watchers.ZombieWatcher;
import org.bukkit.DyeColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Axolotl;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Frog;
import org.bukkit.entity.Horse;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Panda;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.TropicalFish;
import org.bukkit.entity.Villager;

public class TARDISLazarusLibs {
    private final Player player;
    private final String disguise;
    private final Object choice;
    private final boolean hasOption;
    private final boolean isBaby;

    public TARDISLazarusLibs(Player player, String disguise, Object choice, boolean hasOption, boolean isBaby) {
        this.player = player;
        this.disguise = disguise;
        this.choice = choice;
        this.hasOption = hasOption;
        this.isBaby = isBaby;
    }

    public static void removeDisguise(Player player) {
        if (DisguiseAPI.isDisguised((Entity)player)) {
            DisguiseAPI.undisguiseToAll((Entity)player);
        }
    }

    public static void runImmortalityGate(Player player) {
        PlayerDisguise playerDisguise = new PlayerDisguise(player.getName());
        TARDIS.plugin.getServer().getOnlinePlayers().forEach(p -> {
            if (!p.equals((Object)player)) {
                DisguiseAPI.disguiseToAll((Entity)p, (Disguise)playerDisguise);
            }
        });
    }

    public void createDisguise() {
        DisguiseType dt = DisguiseType.valueOf((String)this.disguise);
        if (dt.equals((Object)DisguiseType.PLAYER)) {
            PlayerDisguise playerDisguise = new PlayerDisguise("Herobrine");
            DisguiseAPI.disguiseToAll((Entity)this.player, (Disguise)playerDisguise);
        } else {
            LivingWatcher livingWatcher;
            MobDisguise mobDisguise = new MobDisguise(dt);
            try {
                livingWatcher = mobDisguise.getWatcher();
            }
            catch (NoSuchMethodError e) {
                TARDIS.plugin.getMessenger().message((CommandSender)this.player, "LIBS");
                return;
            }
            switch (dt) {
                case ALLAY: {
                    AllayWatcher allayWatcher = (AllayWatcher)livingWatcher;
                    allayWatcher.setDancing(this.hasOption);
                    break;
                }
                case AXOLOTL: {
                    AxolotlWatcher axolotlWatcher = (AxolotlWatcher)livingWatcher;
                    axolotlWatcher.setVariant((Axolotl.Variant)this.choice);
                    axolotlWatcher.setBaby(this.isBaby);
                    break;
                }
                case CAT: {
                    CatWatcher catWatcher = (CatWatcher)livingWatcher;
                    catWatcher.setType((Cat.Type)this.choice);
                    if (this.hasOption) {
                        catWatcher.setTamed(true);
                    }
                    catWatcher.setBaby(this.isBaby);
                    break;
                }
                case FROG: {
                    FrogWatcher frogWatcher = (FrogWatcher)livingWatcher;
                    frogWatcher.setVariant((Frog.Variant)this.choice);
                    frogWatcher.setBaby(this.isBaby);
                    break;
                }
                case GOAT: {
                    GoatWatcher goatWatcher = (GoatWatcher)livingWatcher;
                    goatWatcher.setBaby(this.isBaby);
                    goatWatcher.setScreaming(this.hasOption);
                    break;
                }
                case PANDA: {
                    PandaWatcher pandaWatcher = (PandaWatcher)livingWatcher;
                    Panda.Gene gene = (Panda.Gene)this.choice;
                    pandaWatcher.setMainGene(gene);
                    pandaWatcher.setHiddenGene(gene);
                    break;
                }
                case DONKEY: 
                case MULE: {
                    ChestedHorseWatcher chestedHorseWatcher = (ChestedHorseWatcher)livingWatcher;
                    chestedHorseWatcher.setCarryingChest(this.hasOption);
                    break;
                }
                case PILLAGER: {
                    PillagerWatcher pillagerWatcher = (PillagerWatcher)livingWatcher;
                    pillagerWatcher.setAimingBow(this.hasOption);
                    break;
                }
                case SHEEP: {
                    SheepWatcher sheepWatcher = (SheepWatcher)livingWatcher;
                    sheepWatcher.setColor((DyeColor)this.choice);
                    sheepWatcher.setBaby(this.isBaby);
                    if (!this.hasOption) break;
                    sheepWatcher.setCustomName("jeb_");
                    sheepWatcher.setCustomNameVisible(true);
                    break;
                }
                case HORSE: {
                    HorseWatcher horseWatcher = (HorseWatcher)livingWatcher;
                    horseWatcher.setColor((Horse.Color)this.choice);
                    horseWatcher.setBaby(this.isBaby);
                    break;
                }
                case LLAMA: {
                    LlamaWatcher llamaWatcher = (LlamaWatcher)livingWatcher;
                    llamaWatcher.setColor((Llama.Color)this.choice);
                    if (!this.hasOption) break;
                    llamaWatcher.setCarpet(DyeColor.values()[TARDISConstants.RANDOM.nextInt(16)]);
                    break;
                }
                case OCELOT: {
                    OcelotWatcher ocelotWatcher = (OcelotWatcher)livingWatcher;
                    ocelotWatcher.setBaby(this.isBaby);
                    ocelotWatcher.setTrusting(this.hasOption);
                    break;
                }
                case PARROT: {
                    ParrotWatcher parrotWatcher = (ParrotWatcher)livingWatcher;
                    parrotWatcher.setVariant((Parrot.Variant)this.choice);
                    parrotWatcher.setBaby(this.isBaby);
                    break;
                }
                case PIG: {
                    PigWatcher pigWatcher = (PigWatcher)livingWatcher;
                    pigWatcher.setSaddled(this.hasOption);
                    pigWatcher.setBaby(this.isBaby);
                    break;
                }
                case RABBIT: {
                    RabbitWatcher rabbitWatcher = (RabbitWatcher)livingWatcher;
                    Rabbit.Type rabbitType = Rabbit.Type.valueOf((String)this.choice.toString());
                    rabbitWatcher.setType(rabbitType);
                    rabbitWatcher.setBaby(this.isBaby);
                    break;
                }
                case VILLAGER: {
                    VillagerWatcher villagerWatcher = (VillagerWatcher)livingWatcher;
                    villagerWatcher.setProfession((Villager.Profession)this.choice);
                    villagerWatcher.setBaby(this.isBaby);
                    break;
                }
                case WARDEN: {
                    WardenWatcher wardenWatcher = (WardenWatcher)livingWatcher;
                    wardenWatcher.setAnger(this.hasOption ? 150 : 0);
                    break;
                }
                case WOLF: {
                    WolfWatcher wolfWatcher = (WolfWatcher)livingWatcher;
                    if (this.hasOption) {
                        wolfWatcher.setTamed(true);
                        wolfWatcher.setCollarColor((DyeColor)this.choice);
                    }
                    wolfWatcher.setBaby(this.isBaby);
                    break;
                }
                case SLIME: 
                case MAGMA_CUBE: {
                    SlimeWatcher slimeWatcher = (SlimeWatcher)livingWatcher;
                    slimeWatcher.setSize(((Integer)this.choice).intValue());
                    break;
                }
                case BAT: {
                    BatWatcher batWatcher = (BatWatcher)livingWatcher;
                    batWatcher.setHanging(!this.hasOption);
                    break;
                }
                case BLAZE: {
                    BlazeWatcher blazeWatcher = (BlazeWatcher)livingWatcher;
                    blazeWatcher.setBlazing(this.hasOption);
                    break;
                }
                case CREEPER: {
                    CreeperWatcher cw = (CreeperWatcher)livingWatcher;
                    cw.setPowered(this.hasOption);
                    break;
                }
                case ENDERMAN: {
                    EndermanWatcher endermanWatcher = (EndermanWatcher)livingWatcher;
                    endermanWatcher.setAggressive(this.hasOption);
                    break;
                }
                case COW: {
                    AgeableWatcher ageableWatcher = (AgeableWatcher)livingWatcher;
                    ageableWatcher.setBaby(this.isBaby);
                    break;
                }
                case ZOMBIE: {
                    ZombieWatcher zombieWatcher = (ZombieWatcher)livingWatcher;
                    zombieWatcher.setBaby(this.isBaby);
                    break;
                }
                case ZOMBIE_VILLAGER: {
                    ZombieVillagerWatcher zombieVillagerWatcher = (ZombieVillagerWatcher)livingWatcher;
                    zombieVillagerWatcher.setBaby(this.isBaby);
                    zombieVillagerWatcher.setProfession((Villager.Profession)this.choice);
                    break;
                }
                case SNOWMAN: {
                    SnowmanWatcher snowmanWatcher = (SnowmanWatcher)livingWatcher;
                    snowmanWatcher.setDerp((Boolean)this.choice == false);
                    break;
                }
                case TURTLE: {
                    TurtleWatcher turtleWatcher = (TurtleWatcher)livingWatcher;
                    turtleWatcher.setBaby(this.isBaby);
                    break;
                }
                case PUFFERFISH: {
                    PufferFishWatcher pufferFishWatcher = (PufferFishWatcher)livingWatcher;
                    pufferFishWatcher.setPuffState(((Integer)this.choice).intValue());
                    break;
                }
                case TROPICAL_FISH: {
                    TropicalFishWatcher tropicalFishWatcher = (TropicalFishWatcher)livingWatcher;
                    tropicalFishWatcher.setPattern((TropicalFish.Pattern)this.choice);
                    tropicalFishWatcher.setBodyColor(DyeColor.values()[TARDISConstants.RANDOM.nextInt(16)]);
                    tropicalFishWatcher.setPatternColor(DyeColor.values()[TARDISConstants.RANDOM.nextInt(16)]);
                    break;
                }
                case MUSHROOM_COW: {
                    MushroomCowWatcher mushroomCowWatcher = (MushroomCowWatcher)livingWatcher;
                    mushroomCowWatcher.setVariant((MushroomCow.Variant)this.choice);
                    break;
                }
                case FOX: {
                    FoxWatcher foxWatcher = (FoxWatcher)livingWatcher;
                    foxWatcher.setType((Fox.Type)this.choice);
                    break;
                }
            }
            DisguiseAPI.disguiseToAll((Entity)this.player, (Disguise)mobDisguise);
        }
    }
}

