/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;

public class TARDISVaultChecker
implements Runnable {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final List<Material> chests = List.of(Material.CHEST, Material.TRAPPED_CHEST);
    private final String prefix;

    public TARDISVaultChecker(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "vaults";
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    Location l = TARDISStaticLocationGetters.getLocationFromBukkitString(rs.getString("location"));
                    if (l == null || !l.getChunk().isLoaded() || this.chests.contains(l.getBlock().getType())) continue;
                    int id = rs.getInt("v_id");
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("v_id", id);
                    this.plugin.getQueryFactory().doDelete("vaults", where);
                    ++i;
                }
            }
            if (i > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Removed " + i + " unused vault room drop chests!");
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for vaults table! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing vaults table! " + e.getMessage());
            }
        }
    }
}

