/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.microscope;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.CraftingDifficulty;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.tardischemistry.microscope.LabEquipment;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class MicroscopeRecipes {
    private final TARDIS plugin;

    public MicroscopeRecipes(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addRecipes() {
        for (LabEquipment equipment : LabEquipment.values()) {
            String name = equipment.getName();
            ItemStack is = ItemStack.of((Material)equipment.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)ComponentUtils.toWhite(name));
            im.setItemModel(equipment.getModel());
            is.setItemMeta(im);
            NamespacedKey key = new NamespacedKey((Plugin)this.plugin, equipment.toString().toLowerCase(Locale.ROOT));
            ShapedRecipe r = new ShapedRecipe(key, is);
            r.shape(new String[]{" A ", "RER", "GGG"});
            if (this.plugin.getCraftingDifficulty() == CraftingDifficulty.HARD) {
                r.setIngredient('A', Material.SPYGLASS);
                r.setIngredient('G', Material.GLASS);
            } else {
                r.setIngredient('A', Material.AMETHYST_SHARD);
                r.setIngredient('G', Material.GLASS_PANE);
            }
            r.setIngredient('R', Material.REDSTONE);
            r.setIngredient('E', equipment.getMaterial());
            this.plugin.getServer().addRecipe((Recipe)r);
            this.plugin.getFigura().getShapedRecipes().put(name, r);
        }
    }
}

