/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.populators;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.schematic.TARDISSchematicGZip;
import me.eccentric_nz.tardischunkgenerator.worldgen.SiluriaProcessData;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.SiluriaStructureUtility;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.TARDISLootTables;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import org.bukkit.Material;
import org.bukkit.block.Chest;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;
import org.bukkit.util.BlockVector;

public class SiluriaStructurePopulator
extends BlockPopulator {
    final List<SiluriaProcessData> toProcess = new ArrayList<SiluriaProcessData>();
    final List<String> noStilts = List.of("east_west", "north_south", "cross");
    final List<Material> buildable = List.of(Material.GRASS_BLOCK, Material.WATER, Material.PODZOL, Material.SAND);
    private final TARDIS plugin;

    public SiluriaStructurePopulator(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void populate(WorldInfo worldInfo, Random random, int x, int z, LimitedRegion limitedRegion) {
        Iterator<SiluriaProcessData> iterator = this.toProcess.iterator();
        while (iterator.hasNext()) {
            SiluriaProcessData xz = iterator.next();
            if (xz.x != x || xz.z != z) continue;
            for (Map.Entry<BlockVector, String> grid : xz.grid.entrySet()) {
                this.build(limitedRegion, x * 16 + grid.getKey().getBlockX(), xz.y, z * 16 + grid.getKey().getBlockZ(), random, grid.getValue());
            }
            iterator.remove();
        }
        if (this.isFeatureChunk(worldInfo.getSeed(), x, z)) {
            int startX = x * 16;
            int startY = 128;
            int startZ = z * 16;
            for (int i = 128; i > 60 && !this.buildable.contains(limitedRegion.getType(startX, startY, startZ)); --i) {
                --startY;
            }
            if (limitedRegion.isInRegion(startX, startY, startZ) && limitedRegion.getBuffer() > 15) {
                for (Map.Entry<BlockVector, HashMap<BlockVector, String>> entry : SiluriaStructureUtility.centres.entrySet()) {
                    this.toProcess.add(new SiluriaProcessData(x + entry.getKey().getBlockX(), startY, z + entry.getKey().getBlockZ(), entry.getValue()));
                }
                for (Map.Entry<BlockVector, Object> entry : SiluriaStructureUtility.vectorZero.entrySet()) {
                    this.build(limitedRegion, startX + entry.getKey().getBlockX(), startY, startZ + entry.getKey().getBlockZ(), random, (String)entry.getValue());
                }
            }
        }
    }

    public boolean isFeatureChunk(long seed, int x, int z) {
        RandomSpreadStructurePlacement spread = new RandomSpreadStructurePlacement(32, 8, RandomSpreadType.LINEAR, 14357620);
        ChunkPos chunkPos = spread.getPotentialStructureChunk(seed, x, z);
        return chunkPos.x == x && chunkPos.z == z;
    }

    private void build(LimitedRegion limitedRegion, int startX, int startY, int startZ, Random random, String which) {
        String path = "schematics/siluria_" + which + ".tschm";
        InputStream stream = this.plugin.getResource(path);
        if (stream != null) {
            JsonObject obj = TARDISSchematicGZip.unzip(stream);
            JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
            int h = dimensions.get("height").getAsInt() - 1;
            int w = dimensions.get("width").getAsInt();
            int d = dimensions.get("length").getAsInt() - 1;
            int level = 0;
            int row = 0;
            if (this.noStilts.contains(which)) {
                startY += 17;
            }
            JsonArray arr = obj.get("input").getAsJsonArray();
            while (level <= h && row < w) {
                JsonArray floor = arr.get(level).getAsJsonArray();
                JsonArray r = floor.get(row).getAsJsonArray();
                for (int col = 0; col <= d; ++col) {
                    JsonObject c = r.get(col).getAsJsonObject();
                    int x = startX + row;
                    int y = startY + level;
                    int z = startZ + col;
                    BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                    Material type = data.getMaterial();
                    if (limitedRegion.isInRegion(x, y, z)) {
                        switch (type) {
                            case AIR: {
                                if (level <= h - (which.equals("temple") ? 7 : 6) || this.noStilts.contains(which)) break;
                                limitedRegion.setBlockData(x, y, z, data);
                                break;
                            }
                            case CHEST: {
                                limitedRegion.setBlockData(x, y, z, data);
                                if (!limitedRegion.getType(x, y, z).equals((Object)Material.CHEST)) break;
                                Chest container = (Chest)limitedRegion.getBlockState(x, y, z);
                                container.setLootTable(TARDISLootTables.LOOT.get(random.nextInt(11)));
                                container.update();
                                break;
                            }
                            case SPONGE: {
                                if (limitedRegion.getType(x, y, z).isOccluding()) break;
                                limitedRegion.setType(x, y, z, Material.AIR);
                                break;
                            }
                            case SPAWNER: {
                                limitedRegion.setBlockData(x, y, z, data);
                                CreatureSpawner cs = (CreatureSpawner)limitedRegion.getBlockState(x, y, z);
                                cs.setSpawnedType(EntityType.SKELETON);
                                cs.update();
                                break;
                            }
                            default: {
                                limitedRegion.setBlockData(x, y, z, data);
                                if (level != 0 || this.noStilts.contains(which) || data.getMaterial().equals((Object)Material.AIR)) break;
                                int yy = y - 1;
                                while (limitedRegion.getType(x, yy, z).isAir() || limitedRegion.getType(x, yy, z).equals((Object)Material.WATER)) {
                                    limitedRegion.setType(x, yy, z, Material.JUNGLE_LOG);
                                    --yy;
                                }
                                break block0;
                            }
                        }
                    }
                    if (col == d && row < w) {
                        ++row;
                    }
                    if (col != d || row != w || level >= h) continue;
                    row = 0;
                    ++level;
                }
            }
        }
    }
}

