/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.areas;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;

public class TARDISAreaListener
implements Listener {
    private final TARDIS plugin;

    public TARDISAreaListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onAreaInteract(PlayerInteractEvent event) {
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        Block block = event.getClickedBlock();
        if (block != null) {
            if (this.plugin.getTrackerKeeper().getArea().containsKey(uuid) && !this.plugin.getTrackerKeeper().getAreaStartBlock().containsKey(uuid)) {
                Location block_loc = block.getLocation();
                if (!this.plugin.getTardisArea().isInExistingArea(block_loc)) {
                    String locStr = block_loc.getWorld().getName() + ":" + block_loc.getBlockX() + ":" + block_loc.getBlockY() + ":" + block_loc.getBlockZ();
                    this.plugin.getTrackerKeeper().getAreaStartBlock().put(uuid, locStr);
                    this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "AREA_END_INFO", "/tardisarea end", this.plugin);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        this.plugin.getTrackerKeeper().getArea().remove(uuid);
                        this.plugin.getTrackerKeeper().getAreaStartBlock().remove(uuid);
                    }, 1200L);
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_INSIDE");
                }
            } else if (this.plugin.getTrackerKeeper().getAreaStartBlock().containsKey(uuid) && this.plugin.getTrackerKeeper().getAreaEndBlock().containsKey(uuid)) {
                Location block_loc = block.getLocation();
                if (!this.plugin.getTardisArea().isInExistingArea(block_loc)) {
                    int maxz;
                    int minz;
                    int maxx;
                    int minx;
                    String[] firstblock = this.plugin.getTrackerKeeper().getAreaStartBlock().get(uuid).split(":");
                    if (!block_loc.getWorld().getName().equals(firstblock[0])) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_WORLD");
                        return;
                    }
                    int y = block_loc.getBlockY();
                    if (y != TARDISNumberParsers.parseInt(firstblock[2])) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_Y");
                        return;
                    }
                    if (TARDISNumberParsers.parseInt(firstblock[1]) < block_loc.getBlockX()) {
                        minx = TARDISNumberParsers.parseInt(firstblock[1]);
                        maxx = block_loc.getBlockX();
                    } else {
                        minx = block_loc.getBlockX();
                        maxx = TARDISNumberParsers.parseInt(firstblock[1]);
                    }
                    if (TARDISNumberParsers.parseInt(firstblock[3]) < block_loc.getBlockZ()) {
                        minz = TARDISNumberParsers.parseInt(firstblock[3]);
                        maxz = block_loc.getBlockZ();
                    } else {
                        minz = block_loc.getBlockZ();
                        maxz = TARDISNumberParsers.parseInt(firstblock[3]);
                    }
                    String n = this.plugin.getTrackerKeeper().getArea().get(uuid);
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("area_name", n);
                    set.put("world", firstblock[0]);
                    set.put("minx", minx);
                    set.put("minz", minz);
                    set.put("maxx", maxx);
                    set.put("maxz", maxz);
                    set.put("y", y + 1);
                    this.plugin.getQueryFactory().doInsert("areas", set);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_SAVED", this.plugin.getTrackerKeeper().getArea().get(uuid));
                    this.plugin.getTrackerKeeper().getArea().remove(uuid);
                    this.plugin.getTrackerKeeper().getAreaStartBlock().remove(uuid);
                    this.plugin.getTrackerKeeper().getAreaEndBlock().remove(uuid);
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_INSIDE");
                }
            }
        }
    }
}

