/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISAbandoned;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class TARDISAbandonedCommand {
    private final TARDIS plugin;

    TARDISAbandonedCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean spawn(CommandSender sender, String[] args) {
        Location l;
        COMPASS d;
        ChameleonPreset preset;
        if (!this.plugin.getConfig().getBoolean("abandon.enabled")) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ABANDONED_DISABLED");
            return true;
        }
        if (!this.plugin.getConfig().getBoolean("creation.default_world")) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ABANDONED_SPAWN");
            return true;
        }
        if (args.length < 4) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ABANDONED_ARGS");
            return true;
        }
        String schm = args[1].toUpperCase(Locale.ROOT);
        if (!Consoles.getBY_NAMES().containsKey(schm)) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return true;
        }
        Schematic s = Consoles.getBY_NAMES().get(schm);
        if (this.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false).contains(args[2])) {
            preset = ChameleonPreset.ITEM;
        } else {
            try {
                preset = ChameleonPreset.valueOf(args[2].toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ABANDONED_PRESET");
                return true;
            }
        }
        try {
            d = COMPASS.valueOf(args[3].toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ABANDONED_COMPASS");
            return true;
        }
        if (sender instanceof Player) {
            Player p = (Player)sender;
            l = p.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 16).getRelative(BlockFace.UP).getLocation();
        } else {
            if (args.length < 8) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ABANDONED_ARGS");
                return true;
            }
            World w = TARDISAliasResolver.getWorldFromAlias(args[4]);
            if (w == null) {
                this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld", this.plugin);
                return true;
            }
            int x = TARDISNumberParsers.parseInt(args[5]);
            int y = TARDISNumberParsers.parseInt(args[6]);
            int z = TARDISNumberParsers.parseInt(args[7]);
            if (x == 0 || y == 0 || z == 0) {
                this.plugin.getMessenger().sendColouredCommand(sender, "WORLD_NOT_FOUND", "/tardisworld", this.plugin);
                return true;
            }
            l = new Location(w, (double)x, (double)y, (double)z);
        }
        new TARDISAbandoned(this.plugin).spawn(l, s, preset, args[2], d, sender instanceof Player ? (Player)sender : null);
        return true;
    }
}

