/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Repeater;

public class ResultSetRepeaters {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final int secondary;
    private final int[] diodes = new int[4];
    private final List<Location> locations = new ArrayList<Location>();
    private final String prefix;

    public ResultSetRepeaters(TARDIS plugin, int id, int secondary) {
        this.plugin = plugin;
        this.id = id;
        this.secondary = secondary;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block17: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT DISTINCT location, type FROM " + this.prefix + "controls WHERE tardis_id = ? AND type IN (2,3,4,5) AND secondary = ? ORDER BY type";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setInt(1, this.id);
                statement.setInt(2, this.secondary);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        this.locations.add(TARDISStaticLocationGetters.getLocationFromDB(rs.getString("location")));
                    }
                    break block17;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for controls table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing controls table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int[] getRepeaters() {
        if (this.locations.size() == 4) {
            BlockData r0 = this.locations.getFirst().getBlock().getBlockData();
            BlockData r1 = this.locations.get(1).getBlock().getBlockData();
            BlockData r2 = this.locations.get(2).getBlock().getBlockData();
            BlockData r3 = this.locations.get(3).getBlock().getBlockData();
            this.diodes[0] = r0 instanceof Repeater ? ((Repeater)r0).getDelay() : -1;
            this.diodes[1] = r1 instanceof Repeater ? ((Repeater)r1).getDelay() : 1;
            this.diodes[2] = r2 instanceof Repeater ? ((Repeater)r2).getDelay() : 1;
            this.diodes[3] = r3 instanceof Repeater ? ((Repeater)r3).getDelay() : 1;
        } else {
            this.diodes[0] = -1;
        }
        return this.diodes;
    }

    public List<Location> getLocations() {
        return this.locations;
    }
}

