/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.doors.inner;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetOuterPortal;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Openable;
import org.bukkit.entity.Player;

public class InnerMinecraftDoorOpener {
    private final TARDIS plugin;

    public InnerMinecraftDoorOpener(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void open(Block block, int id) {
        block19: {
            if (Tag.DOORS.isTagged((Keyed)block.getType())) {
                Openable openable = (Openable)block.getBlockData();
                openable.setOpen(true);
                block.setBlockData((BlockData)openable, true);
            }
            if (this.plugin.getTrackerKeeper().getWoolToggles().contains(id)) break block19;
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (rs.resultSet()) {
                Tardis tardis = rs.getTardis();
                ChameleonPreset preset = tardis.getPreset();
                Location portal = block.getLocation();
                ResultSetOuterPortal resultSetPortal = new ResultSetOuterPortal(this.plugin, id);
                if (resultSetPortal.resultSet()) {
                    Location teleport = resultSetPortal.getLocation().clone();
                    if (preset.usesArmourStand() || preset == ChameleonPreset.INVISIBLE) {
                        switch (resultSetPortal.getDirection()) {
                            case NORTH_EAST: {
                                teleport.add(0.0, 0.0, 1.0);
                                break;
                            }
                            case NORTH: {
                                teleport.add(0.5, 0.0, 1.0);
                                break;
                            }
                            case NORTH_WEST: {
                                teleport.add(1.0, 0.0, 1.0);
                                break;
                            }
                            case WEST: {
                                teleport.add(1.0, 0.0, 0.5);
                                break;
                            }
                            case SOUTH_WEST: {
                                teleport.add(1.0, 0.0, -0.5);
                                break;
                            }
                            case SOUTH: {
                                teleport.add(0.5, 0.0, -1.0);
                                break;
                            }
                            case SOUTH_EAST: {
                                teleport.add(-0.5, 0.0, 0.0);
                                break;
                            }
                            default: {
                                teleport.add(-1.0, 0.0, 0.5);
                                break;
                            }
                        }
                    } else {
                        teleport.setX(teleport.getX() + 0.5);
                        teleport.setZ(teleport.getZ() + 0.5);
                    }
                    TARDISTeleportLocation tp_out = new TARDISTeleportLocation();
                    tp_out.setLocation(teleport);
                    tp_out.setTardisId(id);
                    tp_out.setDirection(resultSetPortal.getDirection());
                    tp_out.setAbandoned(tardis.isAbandoned());
                    this.plugin.getTrackerKeeper().getPortals().put(portal, tp_out);
                    if (!this.plugin.getConfig().getBoolean("preferences.open_door_policy")) {
                        this.plugin.getTrackerKeeper().getMovers().add(tardis.getUuid());
                        if (tardis.getCompanions().equalsIgnoreCase("everyone")) {
                            for (Player p : Bukkit.getServer().getOnlinePlayers()) {
                                this.plugin.getTrackerKeeper().getMovers().add(p.getUniqueId());
                            }
                        } else {
                            String[] companions;
                            for (String c : companions = tardis.getCompanions().split(":")) {
                                if (c.isEmpty()) continue;
                                this.plugin.getTrackerKeeper().getMovers().add(UUID.fromString(c));
                            }
                        }
                    }
                }
            }
        }
    }
}

