/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.desktop.TARDISUpgradeData;
import me.eccentric_nz.TARDIS.enumeration.Consoles;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.FloodgateDesktopArchiveForm;
import me.eccentric_nz.TARDIS.floodgate.FloodgateWallFloorForm;
import me.eccentric_nz.TARDIS.schematic.archive.ArchiveUpdate;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateDesktopThemeForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final String path = "https://raw.githubusercontent.com/eccentricdevotion/TARDIS-Resource-Pack/master/assets/tardis/textures/block/seed/%s.png";
    private final HashMap<String, String> blocks = new HashMap();

    public FloodgateDesktopThemeForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.blocks.put("ANCIENT", "sculk");
        this.blocks.put("ARS", "quartz");
        this.blocks.put("BIGGER", "gold");
        this.blocks.put("BONE", "waxed_oxidized_cut_copper");
        this.blocks.put("BUDGET", "iron");
        this.blocks.put("CAVE", "cave");
        this.blocks.put("COPPER", "warped_planks");
        this.blocks.put("CORAL", "netherwart");
        this.blocks.put("CURSED", "black_concrete");
        this.blocks.put("CUSTOM", "custom");
        this.blocks.put("DELTA", "crying_obsidian");
        this.blocks.put("DELUXE", "diamond");
        this.blocks.put("DIVISION", "pink_glazed");
        this.blocks.put("ELEVENTH", "emerald");
        this.blocks.put("ENDER", "purpur");
        this.blocks.put("FACTORY", "yellow_concrete_powder");
        this.blocks.put("FIFTEENTH", "ochre_froglight");
        this.blocks.put("FUGITIVE", "polished_deepslate");
        this.blocks.put("HOSPITAL", "white_concrete");
        this.blocks.put("LEGACY_BIGGER", "orange_glazed");
        this.blocks.put("LEGACY_DELUXE", "lime_glazed");
        this.blocks.put("LEGACY_ELEVENTH", "cyan_glazed");
        this.blocks.put("LEGACY_REDSTONE", "red_glazed");
        this.blocks.put("MASTER", "netherbrick");
        this.blocks.put("MECHANICAL", "polished_andesite");
        this.blocks.put("ORIGINAL", "packed_mud");
        this.blocks.put("PLANK", "plank");
        this.blocks.put("PYRAMID", "sandstone");
        this.blocks.put("REDSTONE", "redstone");
        this.blocks.put("ROTOR", "honeycomb_block");
        this.blocks.put("RUSTIC", "copper_bulb");
        this.blocks.put("STEAMPUNK", "coal");
        this.blocks.put("THIRTEENTH", "orange_concrete");
        this.blocks.put("TOM", "lapis");
        this.blocks.put("TWELFTH", "prismarine");
        this.blocks.put("WAR", "white_terracotta");
        this.blocks.put("WEATHERED", "weathered");
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Upgrade Menu");
        for (Map.Entry<String, Schematic> a : Consoles.getBY_NAMES().entrySet()) {
            Material m = a.getValue().getSeedMaterial();
            if (m.equals((Object)Material.COBBLESTONE)) continue;
            builder.button(a.getKey(), FormImage.Type.URL, String.format("https://raw.githubusercontent.com/eccentricdevotion/TARDIS-Resource-Pack/master/assets/tardis/textures/block/seed/%s.png", this.blocks.get(a.getKey())));
        }
        builder.button("Archive Consoles", FormImage.Type.URL, "https://raw.githubusercontent.com/eccentricdevotion/TARDIS-Resource-Pack/master/assets/tardis/textures/item/gui/theme/archive.png");
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        String label = response.clickedButton().text();
        if (label.equals("Archive Consoles")) {
            new FloodgateDesktopArchiveForm(this.plugin, this.uuid).send();
        } else {
            Schematic schm = Consoles.getBY_NAMES().get(label);
            if (schm != null) {
                String perm;
                Player player = this.plugin.getServer().getPlayer(this.uuid);
                if (TARDISPermission.hasPermission(player, "tardis." + (perm = schm.getPermission()))) {
                    int needed;
                    TARDISUpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(this.uuid);
                    int upgrade = this.plugin.getArtronConfig().getInt("upgrades." + perm);
                    int n = needed = tud.getPrevious().getPermission().equals(schm.getPermission()) ? upgrade / 2 : upgrade;
                    if (tud.getLevel() >= needed) {
                        tud.setSchematic(schm);
                        this.plugin.getTrackerKeeper().getUpgrades().put(player.getUniqueId(), tud);
                        if (tud.getPrevious().getPermission().equals("archive")) {
                            new ArchiveUpdate(this.plugin, player.getUniqueId().toString(), "\u00aa\u00b0\u00ba").setInUse();
                        }
                        new FloodgateWallFloorForm(this.plugin, this.uuid, "Wall").send();
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_NO_ENERGY", label);
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_UPGRADE_CONSOLE");
                }
            }
        }
    }
}

