/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.hads;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class TARDISHadsPersister {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String prefix;
    private PreparedStatement ps = null;
    private ResultSet rs = null;
    private int count = 0;

    public TARDISHadsPersister(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        try {
            this.ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + "dispersed (uuid, world, x, y, z, tardis_id) VALUES (?, ?, ?, ?, ?, ?)");
            for (Map.Entry<UUID, Location> map : this.plugin.getTrackerKeeper().getDispersed().entrySet()) {
                Location l = map.getValue();
                String uuid = map.getKey().toString();
                this.ps.setString(1, uuid);
                this.ps.setString(2, l.getWorld().getName());
                this.ps.setInt(3, l.getBlockX());
                this.ps.setInt(4, l.getBlockY());
                this.ps.setInt(5, l.getBlockZ());
                ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                rst.fromUUID(uuid);
                this.ps.setInt(6, rst.getTardisId());
                this.count += this.ps.executeUpdate();
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Saved " + this.count + " dispersed TARDISes.");
            }
        }
        catch (SQLException ex) {
            this.plugin.debug("Insert error for dispersed table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing dispersed statement: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        try {
            this.ps = this.connection.prepareStatement("SELECT * FROM " + this.prefix + "dispersed");
            this.rs = this.ps.executeQuery();
            while (this.rs.next()) {
                World world = TARDISAliasResolver.getWorldFromAlias(this.rs.getString("world"));
                if (world == null) continue;
                UUID uuid = UUID.fromString(this.rs.getString("uuid"));
                Location l = new Location(world, (double)this.rs.getInt("x"), (double)this.rs.getInt("y"), (double)this.rs.getInt("z"));
                this.plugin.getTrackerKeeper().getDispersed().put(uuid, l);
                this.plugin.getTrackerKeeper().getDispersedTARDII().add(this.rs.getInt("tardis_id"));
                ++this.count;
            }
            if (this.count > 0) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Loaded " + this.count + " dispersed Police Boxes.");
            }
            this.ps = this.connection.prepareStatement("DELETE FROM " + this.prefix + "dispersed");
            this.ps.executeUpdate();
        }
        catch (SQLException ex) {
            this.plugin.debug("ResultSet error for dispersed table: " + ex.getMessage());
        }
        finally {
            try {
                if (this.ps != null) {
                    this.ps.close();
                }
                if (this.rs != null) {
                    this.rs.close();
                }
            }
            catch (SQLException ex) {
                this.plugin.debug("Error closing dispersed statement or resultset: " + ex.getMessage());
            }
        }
    }
}

