/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.messaging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.companionGUI.TARDISCompanionInventory;
import me.eccentric_nz.TARDIS.database.data.Area;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISLister {
    private final TARDIS plugin;

    public TARDISLister(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void list(Player player, String list) {
        int n;
        if (list.equals("rechargers")) {
            Set therechargers = TARDIS.plugin.getConfig().getConfigurationSection("rechargers").getKeys(false);
            if (therechargers.isEmpty()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHARGER_NONE");
            }
            this.plugin.getMessenger().messageWithColour((CommandSender)player, "TARDIS Rechargers", "#FFAA00");
            this.plugin.getMessenger().message((CommandSender)player, "Hover to see location (world x, y, z)");
            if (TARDISPermission.hasPermission(player, "tardis.admin")) {
                this.plugin.getMessenger().message((CommandSender)player, "Click to /tardisteleport");
            }
            this.plugin.getMessenger().message((CommandSender)player, "");
            n = 1;
            for (String s : therechargers) {
                if (s.startsWith("rift")) continue;
                String world = TARDIS.plugin.getConfig().getString("rechargers." + s + ".world");
                String w = !this.plugin.getPlanetsConfig().getBoolean("planets." + world + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(world) : TARDISAliasResolver.getWorldAlias(world);
                String x = TARDIS.plugin.getConfig().getString("rechargers." + s + ".x");
                String y = TARDIS.plugin.getConfig().getString("rechargers." + s + ".y");
                String z = TARDIS.plugin.getConfig().getString("rechargers." + s + ".z");
                this.plugin.getMessenger().sendRecharger((CommandSender)player, n + ". " + s, w, x, y, z, TARDISPermission.hasPermission(player, "tardis.admin"));
                ++n;
            }
        }
        if (list.equals("areas")) {
            ResultSetAreas rsa = new ResultSetAreas(TARDIS.plugin, null, true, false);
            n = 1;
            if (!rsa.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NONE");
            }
            for (Area a : rsa.getData()) {
                if (n == 1) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREAS");
                    this.plugin.getMessenger().message((CommandSender)player, "");
                }
                this.plugin.getMessenger().sendArea((CommandSender)player, a, n, TARDISPermission.hasPermission(player, "tardis.area." + a.areaName()) || TARDISPermission.hasPermission(player, "tardis.area.*"));
                ++n;
            }
        } else {
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", player.getUniqueId().toString());
            ResultSetTardis rst = new ResultSetTardis(TARDIS.plugin, where, "", false);
            if (rst.resultSet()) {
                Tardis tardis = rst.getTardis();
                int id = tardis.getTardisId();
                if (list.equalsIgnoreCase("saves")) {
                    this.plugin.getMessenger().messageWithColour((CommandSender)player, "TARDIS " + this.plugin.getLanguage().getString("SAVES"), "#FFAA00");
                    this.plugin.getMessenger().message((CommandSender)player, "Hover to see location (world x, y, z)");
                    this.plugin.getMessenger().message((CommandSender)player, "Click to /tardistravel");
                    this.plugin.getMessenger().message((CommandSender)player, "");
                    HashMap<String, Object> wherehl = new HashMap<String, Object>();
                    wherehl.put("tardis_id", id);
                    ResultSetHomeLocation rsh = new ResultSetHomeLocation(TARDIS.plugin, wherehl);
                    rsh.resultSet();
                    String homeWorld = !this.plugin.getPlanetsConfig().getBoolean("planets." + rsh.getWorld().getName() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(rsh.getWorld()) : TARDISAliasResolver.getWorldAlias(rsh.getWorld());
                    this.plugin.getMessenger().sendHome((CommandSender)player, this.plugin, homeWorld, rsh.getX(), rsh.getY(), rsh.getZ());
                    HashMap<String, Object> whered = new HashMap<String, Object>();
                    whered.put("tardis_id", id);
                    ResultSetDestinations rsd = new ResultSetDestinations(TARDIS.plugin, whered, true);
                    if (rsd.resultSet()) {
                        ArrayList<HashMap<String, String>> data = rsd.getData();
                        for (HashMap<String, String> map : data) {
                            if (!map.get("type").equals("0")) continue;
                            String world = !this.plugin.getPlanetsConfig().getBoolean("planets." + map.get("world") + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE) ? this.plugin.getMVHelper().getAlias(map.get("world")) : TARDISAliasResolver.getWorldAlias(map.get("world"));
                            this.plugin.getMessenger().sendSave((CommandSender)player, map, world);
                        }
                    }
                }
                if (list.equalsIgnoreCase("companions")) {
                    String comps = tardis.getCompanions();
                    if (comps != null && !comps.isEmpty()) {
                        String[] companionData = comps.split(":");
                        player.openInventory(new TARDISCompanionInventory(this.plugin, companionData).getInventory());
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COMPANIONS_NONE");
                    }
                }
            }
        }
    }
}

