/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.achievement;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.bukkit.entity.Player;

class TARDISXPRewarder {
    private static final int hardMaxLevel = 100000;
    private static int[] xpTotalToReachLevel;
    private final WeakReference<Player> player;
    private final String playerName;

    TARDISXPRewarder(Player player) {
        if (player == null) {
            throw new IllegalArgumentException("Player cannot be null");
        }
        this.player = new WeakReference<Player>(player);
        this.playerName = player.getName();
    }

    private static void initLookupTables(int maxLevel) {
        xpTotalToReachLevel = new int[maxLevel];
        for (int i = 0; i < xpTotalToReachLevel.length; ++i) {
            TARDISXPRewarder.xpTotalToReachLevel[i] = i >= 30 ? (int)(3.5 * (double)i * (double)i - 151.5 * (double)i + 2220.0) : (i >= 16 ? (int)(1.5 * (double)i * (double)i - 29.5 * (double)i + 360.0) : 17 * i);
        }
    }

    private static int calculateLevelForExp(int exp) {
        int level = 0;
        int curExp = 7;
        int incr = 10;
        while (curExp <= exp) {
            curExp += incr;
            incr += ++level % 2 == 0 ? 3 : 4;
        }
        return level;
    }

    private Player getPlayer() {
        Player p = (Player)this.player.get();
        if (p == null) {
            throw new IllegalStateException("Player " + this.playerName + " is not online");
        }
        return p;
    }

    void changeExp(int amt) {
        this.changeExp((double)amt);
    }

    private void changeExp(double amt) {
        this.setExp(this.getCurrentFractionalXP(), amt);
    }

    private void setExp(double base, double amt) {
        int newLvl;
        int xp = (int)Math.max(base + amt, 0.0);
        Player p = this.getPlayer();
        int curLvl = p.getLevel();
        if (curLvl != (newLvl = this.getLevelForExp(xp))) {
            p.setLevel(newLvl);
        }
        if ((double)xp > base) {
            p.setTotalExperience(p.getTotalExperience() + xp - (int)base);
        }
        double pct = (base - (double)this.getXpForLevel(newLvl) + amt) / (double)this.getXpNeededToLevelUp(newLvl);
        p.setExp((float)pct);
    }

    private double getCurrentFractionalXP() {
        Player p = this.getPlayer();
        int lvl = p.getLevel();
        return (double)this.getXpForLevel(lvl) + (double)((float)this.getXpNeededToLevelUp(lvl) * p.getExp());
    }

    private int getLevelForExp(int exp) {
        int pos;
        if (exp <= 0) {
            return 0;
        }
        if (exp > xpTotalToReachLevel[xpTotalToReachLevel.length - 1]) {
            int newMax = TARDISXPRewarder.calculateLevelForExp(exp) * 2;
            if (newMax > 100000) {
                throw new IllegalArgumentException("Level for exp " + exp + " > hard max level 100000");
            }
            TARDISXPRewarder.initLookupTables(newMax);
        }
        return (pos = Arrays.binarySearch(xpTotalToReachLevel, exp)) < 0 ? -pos - 2 : pos;
    }

    private int getXpNeededToLevelUp(int level) {
        if (level < 0) {
            throw new IllegalArgumentException("Level may not be negative.");
        }
        return level > 30 ? 62 + (level - 30) * 7 : (level >= 16 ? 17 + (level - 15) * 3 : 17);
    }

    private int getXpForLevel(int level) {
        if (level < 0 || level > 100000) {
            throw new IllegalArgumentException("Invalid level " + level + "(must be in range 0..100000)");
        }
        if (level >= xpTotalToReachLevel.length) {
            TARDISXPRewarder.initLookupTables(level * 2);
        }
        return xpTotalToReachLevel[level];
    }

    static {
        TARDISXPRewarder.initLookupTables(25);
    }
}

