/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISSerializeInventory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISCircuitChecker {
    private final TARDIS plugin;
    private final int id;
    private boolean ars;
    private boolean chameleon;
    private boolean input;
    private boolean invisibility;
    private boolean materialisation;
    private boolean memory;
    private boolean randomiser;
    private boolean scanner;
    private boolean telepathic;
    private boolean temporal;
    private int arsUses;
    private int chameleonUses;
    private int inputUses;
    private int invisibilityUses;
    private int materialisationUses;
    private int memoryUses;
    private int randomiserUses;
    private int scannerUses;
    private int temporalUses;
    private int telepathicUses;

    public TARDISCircuitChecker(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
        this.ars = false;
        this.chameleon = false;
        this.input = false;
        this.invisibility = false;
        this.materialisation = false;
        this.memory = false;
        this.randomiser = false;
        this.scanner = false;
        this.telepathic = false;
        this.temporal = false;
        this.arsUses = 0;
        this.chameleonUses = 0;
        this.inputUses = 0;
        this.invisibilityUses = 0;
        this.materialisationUses = 0;
        this.memoryUses = 0;
        this.randomiserUses = 0;
        this.scannerUses = 0;
        this.telepathicUses = 0;
        this.temporalUses = 0;
    }

    public void getCircuits() {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        ResultSetDiskStorage rs = new ResultSetDiskStorage(this.plugin, where);
        if (rs.resultSet()) {
            try {
                ItemStack[] items;
                for (ItemStack is : items = TARDISSerializeInventory.itemStacksFromString(rs.getConsole())) {
                    ItemMeta im;
                    if (is == null || !is.hasItemMeta() || !(im = is.getItemMeta()).hasDisplayName()) continue;
                    String dn = ComponentUtils.stripColour(im.displayName());
                    if (dn.endsWith("TARDIS ARS Circuit")) {
                        this.ars = true;
                        this.arsUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Chameleon Circuit")) {
                        this.chameleon = true;
                        this.chameleonUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Input Circuit")) {
                        this.input = true;
                        this.inputUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Invisibility Circuit")) {
                        this.invisibility = true;
                        this.invisibilityUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Materialisation Circuit")) {
                        this.materialisation = true;
                        this.materialisationUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Memory Circuit")) {
                        this.memory = true;
                        this.memoryUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Randomiser Circuit")) {
                        this.randomiser = true;
                        this.randomiserUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Scanner Circuit")) {
                        this.scanner = true;
                        this.scannerUses = this.getUses(im);
                    }
                    if (dn.endsWith("TARDIS Telepathic Circuit")) {
                        this.telepathic = true;
                        this.telepathicUses = this.getUses(im);
                    }
                    if (!dn.endsWith("TARDIS Temporal Circuit")) continue;
                    this.temporal = true;
                    this.temporalUses = this.getUses(im);
                }
            }
            catch (IOException ex) {
                this.plugin.debug("Could not get console items: " + String.valueOf(ex));
            }
        }
    }

    public boolean hasARS() {
        return this.ars;
    }

    public boolean hasChameleon() {
        return this.chameleon;
    }

    public boolean hasInput() {
        return this.input;
    }

    public boolean hasInvisibility() {
        return this.invisibility;
    }

    public boolean hasMaterialisation() {
        return this.materialisation;
    }

    public boolean hasMemory() {
        return this.memory;
    }

    public boolean hasRandomiser() {
        return this.randomiser;
    }

    public boolean hasScanner() {
        return this.scanner;
    }

    public boolean hasTelepathic() {
        return this.telepathic;
    }

    public boolean hasTemporal() {
        return this.temporal;
    }

    public int getArsUses() {
        return this.arsUses;
    }

    public int getChameleonUses() {
        return this.chameleonUses;
    }

    public int getInputUses() {
        return this.inputUses;
    }

    public int getInvisibilityUses() {
        return this.invisibilityUses;
    }

    public int getMaterialisationUses() {
        return this.materialisationUses;
    }

    public int getMemoryUses() {
        return this.memoryUses;
    }

    public int getRandomiserUses() {
        return this.randomiserUses;
    }

    public int getScannerUses() {
        return this.scannerUses;
    }

    public int getTelepathicUses() {
        return this.telepathicUses;
    }

    public int getTemporalUses() {
        return this.temporalUses;
    }

    private int getUses(ItemMeta im) {
        List lore;
        String stripped;
        int uses = 0;
        if (im.hasLore() && !(stripped = ComponentUtils.stripColour((Component)(lore = im.lore()).get(1))).equals("unlimited")) {
            uses = TARDISNumberParsers.parseInt(stripped);
        }
        return uses;
    }
}

