/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.customblocks.ArtronFurnaceUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.custommodels.keys.Whoniverse;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.Furnace;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Display;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.inventory.FurnaceBurnEvent;
import org.bukkit.event.inventory.FurnaceSmeltEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.FurnaceInventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISArtronFurnaceListener
implements Listener {
    private final TARDIS plugin;
    private final double burnFactor;
    private final int cookTime;

    public TARDISArtronFurnaceListener(TARDIS plugin) {
        this.plugin = plugin;
        this.burnFactor = (double)plugin.getArtronConfig().getInt("artron_furnace.burn_limit") * plugin.getArtronConfig().getDouble("artron_furnace.burn_time");
        this.cookTime = 200 * this.plugin.getArtronConfig().getInt("artron_furnace.cook_time");
    }

    public static void setLit(Block block, boolean lit) {
        ItemDisplay display = TARDISDisplayItemUtils.get(block);
        if (display != null) {
            ItemStack itemStack = display.getItemStack();
            ItemMeta im = itemStack.getItemMeta();
            im.setItemModel(lit ? Whoniverse.ARTRON_FURNACE_LIT.getKey() : Whoniverse.ARTRON_FURNACE.getKey());
            itemStack.setItemMeta(im);
            display.setItemStack(itemStack);
            display.setBrightness(new Display.Brightness(15, 15));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArtronFurnaceBurn(FurnaceBurnEvent event) {
        Furnace furnace = (Furnace)event.getBlock().getState();
        String l = furnace.getLocation().toString();
        if (this.plugin.getTardisHelper().isArtronFurnace(event.getBlock())) {
            ItemStack is = event.getFuel().clone();
            if (is.hasItemMeta()) {
                List lore;
                String one;
                ItemMeta im = is.getItemMeta();
                if (im.hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Artron Storage Cell") && !(one = ComponentUtils.stripColour((Component)(lore = im.lore()).get(1))).equals("0")) {
                    this.plugin.getTrackerKeeper().getArtronFurnaces().add(l);
                    TARDISArtronFurnaceListener.setLit(event.getBlock(), true);
                    TARDISSounds.playTARDISSound(furnace.getLocation(), "artron_furnace");
                    int charge_level = TARDISNumberParsers.parseInt(one);
                    double percentage = (double)charge_level / this.plugin.getArtronConfig().getDouble("full_charge");
                    int burnTime = (int)(percentage * this.burnFactor);
                    event.setBurnTime(burnTime);
                    furnace.setCookTimeTotal(this.cookTime);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        lore.set(1, Component.text((String)"0"));
                        im.lore(lore);
                        im.setEnchantmentGlintOverride(null);
                        is.setItemMeta(im);
                        is.removeEnchantment(Enchantment.UNBREAKING);
                        furnace.getInventory().setItem(1, is);
                    }, 2L);
                }
            } else {
                TARDISArtronFurnaceListener.setLit(event.getBlock(), false);
                this.plugin.getTrackerKeeper().getArtronFurnaces().remove(l);
            }
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void furnaceSmeltEvent(FurnaceSmeltEvent event) {
        Furnace furnace = (Furnace)event.getBlock().getState();
        if (this.plugin.getTardisHelper().isArtronFurnace(event.getBlock()) && this.plugin.getTrackerKeeper().getArtronFurnaces().contains(furnace.getLocation().toString())) {
            furnace.setCookTimeTotal(this.cookTime);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getInventory() instanceof FurnaceInventory)) {
            return;
        }
        Furnace furnace = (Furnace)event.getInventory().getHolder(false);
        if (this.plugin.getTardisHelper().isArtronFurnace(furnace.getBlock()) && this.plugin.getTrackerKeeper().getArtronFurnaces().contains(furnace.getLocation().toString()) && (event.getSlot() == 0 || event.getSlot() == 1) && event.getCursor().getType() != Material.AIR && furnace.getCookTime() > this.cookTime) {
            furnace.setCookTimeTotal(this.cookTime);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArtronFurnacePlace(BlockPlaceEvent event) {
        if (!event.getBlock().getType().equals((Object)Material.FURNACE)) {
            return;
        }
        if (!event.getItemInHand().hasItemMeta()) {
            return;
        }
        if (!event.getItemInHand().getItemMeta().hasDisplayName()) {
            return;
        }
        if (!ComponentUtils.endsWith(event.getItemInHand().getItemMeta().displayName(), "TARDIS Artron Furnace")) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.plugin.getUtils().inTARDISWorld(player)) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
            return;
        }
        if (TARDISPermission.hasPermission(player, "tardis.furnace")) {
            Block b = event.getBlock();
            if (this.plugin.getArtronConfig().getBoolean("artron_furnace.particles")) {
                this.plugin.getGeneralKeeper().getArtronFurnaces().add(b);
            }
            this.plugin.getTardisHelper().nameFurnaceGUI(b, "TARDIS Artron Furnace");
            TARDISDisplayItemUtils.set(TARDISDisplayItem.ARTRON_FURNACE, b, -1);
        } else {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_FURNACE");
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onArtronFurnaceBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!block.getType().equals((Object)Material.FURNACE)) {
            return;
        }
        if (this.plugin.getTardisHelper().isArtronFurnace(event.getBlock())) {
            event.setCancelled(true);
            if (this.plugin.getArtronConfig().getBoolean("artron_furnace.particles")) {
                this.plugin.getGeneralKeeper().getArtronFurnaces().remove(block);
            }
            if (this.plugin.getArtronConfig().getBoolean("artron_furnace.tardis_powered")) {
                ArtronFurnaceUtils.remove(block.getLocation().toString(), event.getPlayer(), this.plugin);
            }
            ItemStack is = ItemStack.of((Material)Material.FURNACE, (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)ComponentUtils.toWhite("TARDIS Artron Furnace"));
            is.setItemMeta(im);
            TARDISDisplayItemUtils.remove(block);
            block.setBlockData(TARDISConstants.AIR);
            block.getWorld().dropItemNaturally(event.getPlayer().getLocation(), is);
        }
    }
}

