/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronStorage;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisArtron;
import me.eccentric_nz.TARDIS.sensor.ChargingSensor;
import me.eccentric_nz.TARDIS.sensor.SensorTracker;
import org.bukkit.Location;

class TARDISArtronRunnable
implements Runnable {
    private final TARDIS plugin;
    private final int id;
    private int task;
    private boolean sensor = true;

    TARDISArtronRunnable(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
    }

    @Override
    public void run() {
        boolean charged;
        int capacitors = 0;
        ResultSetArtronStorage rsa = new ResultSetArtronStorage(this.plugin);
        if (rsa.fromID(this.id)) {
            capacitors = rsa.getCapacitorCount();
        }
        int level = this.isFull(this.id);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        boolean bl = charged = level > this.plugin.getArtronConfig().getInt("full_charge") - 1;
        if (!this.isNearCharger(this.id) || charged || capacitors == 0) {
            this.plugin.getServer().getScheduler().cancelTask(this.task);
            this.task = 0;
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("recharging", 0);
            this.plugin.getQueryFactory().doUpdate("tardis", set, where);
            if (charged) {
                new ChargingSensor(this.plugin, this.id).toggle();
                SensorTracker.isCharging.remove(this.id);
            }
        } else {
            if (this.sensor) {
                new ChargingSensor(this.plugin, this.id).toggle();
                this.sensor = false;
                SensorTracker.isCharging.add(this.id);
            }
            int onepercent = Math.round((float)this.plugin.getArtronConfig().getInt("full_charge") / 100.0f);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", onepercent, where, null);
        }
    }

    private boolean isNearCharger(int id) {
        ResultSetCurrentFromId rs = new ResultSetCurrentFromId(this.plugin, id);
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id) || !rs.resultSet()) {
            return false;
        }
        Current current = rs.getCurrent();
        if (current.location().getWorld() == null) {
            return false;
        }
        Location pb_loc = current.location().clone();
        for (Location l : this.plugin.getGeneralKeeper().getRechargers()) {
            if (!this.plugin.getUtils().compareLocations(pb_loc, l)) continue;
            if (this.plugin.getConfig().getBoolean("preferences.strike_lightning")) {
                pb_loc.setY(pb_loc.getY() + 3.0);
                current.location().getWorld().strikeLightningEffect(pb_loc);
            }
            return true;
        }
        return false;
    }

    private int isFull(int id) {
        ResultSetTardisArtron rs = new ResultSetTardisArtron(this.plugin);
        return rs.fromID(id) ? rs.getArtronLevel() : this.plugin.getArtronConfig().getInt("full_charge");
    }

    public void setTask(int task) {
        this.task = task;
    }
}

