/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ColouredVariant;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetColour;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDoors;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisModel;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.entity.ArmorStand;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.plugin.Plugin;

public class TARDISBuilderUtility {
    public static void saveDoorLocation(BuildData bd, boolean slab) {
        World world = bd.getLocation().getWorld();
        int x = bd.getLocation().getBlockX();
        int y = bd.getLocation().getBlockY();
        if (slab) {
            --y;
        }
        int z = bd.getLocation().getBlockZ();
        String doorloc = world.getName() + ":" + x + ":" + y + ":" + z;
        String doorStr = world.getBlockAt(x, y, z).getLocation().toString();
        TARDIS.plugin.getGeneralKeeper().getProtectBlockMap().put(doorStr, bd.getTardisID());
        HashMap<String, Object> whered = new HashMap<String, Object>();
        whered.put("door_type", 0);
        whered.put("tardis_id", bd.getTardisID());
        ResultSetDoors rsd = new ResultSetDoors(TARDIS.plugin, whered, false);
        HashMap<String, Object> setd = new HashMap<String, Object>();
        setd.put("door_location", doorloc);
        setd.put("door_direction", bd.getDirection().forPreset().toString());
        if (rsd.resultSet()) {
            HashMap<String, Object> whereid = new HashMap<String, Object>();
            whereid.put("door_id", rsd.getDoor_id());
            TARDIS.plugin.getQueryFactory().doUpdate("doors", setd, whereid);
        } else {
            setd.put("tardis_id", bd.getTardisID());
            setd.put("door_type", 0);
            TARDIS.plugin.getQueryFactory().doInsert("doors", setd);
        }
    }

    public static void saveDoorLocation(Location location, int id, String direction) {
        World world = location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        String doorloc = world.getName() + ":" + x + ":" + y + ":" + z;
        String doorStr = world.getBlockAt(x, y, z).getLocation().toString();
        TARDIS.plugin.getGeneralKeeper().getProtectBlockMap().put(doorStr, id);
        HashMap<String, Object> whered = new HashMap<String, Object>();
        whered.put("door_type", 0);
        whered.put("tardis_id", id);
        ResultSetDoors rsd = new ResultSetDoors(TARDIS.plugin, whered, false);
        HashMap<String, Object> setd = new HashMap<String, Object>();
        setd.put("door_location", doorloc);
        setd.put("door_direction", direction);
        if (rsd.resultSet()) {
            HashMap<String, Object> whereid = new HashMap<String, Object>();
            whereid.put("door_id", rsd.getDoor_id());
            TARDIS.plugin.getQueryFactory().doUpdate("doors", setd, whereid);
        } else {
            setd.put("tardis_id", id);
            setd.put("door_type", 0);
            TARDIS.plugin.getQueryFactory().doInsert("doors", setd);
        }
    }

    public static Material getMaterialForArmourStand(ChameleonPreset preset, int id, boolean isMaterialisation) {
        switch (preset) {
            case ITEM: {
                ResultSetTardisModel rstm = new ResultSetTardisModel(TARDIS.plugin);
                if (rstm.fromID(id)) {
                    String item = isMaterialisation ? rstm.getItemPreset() : rstm.getItemDemat();
                    return Material.valueOf((String)TARDIS.plugin.getCustomModelConfig().getString("models." + item + ".item"));
                }
                return Material.BLUE_DYE;
            }
            case WEEPING_ANGEL: {
                return Material.GRAY_STAINED_GLASS_PANE;
            }
            case POLICE_BOX_TENNANT: {
                return Material.CYAN_STAINED_GLASS_PANE;
            }
            case COLOURED: {
                return Material.LEATHER_HORSE_ARMOR;
            }
            case PANDORICA: {
                return Material.ENDER_PEARL;
            }
        }
        String split = preset.toString().replace("POLICE_BOX_", "");
        String dye = split + "_DYE";
        return Material.valueOf((String)dye);
    }

    public static void setPoliceBoxHelmet(TARDIS plugin, ChameleonPreset preset, BuildData bd, ArmorStand stand) {
        Material dye = TARDISBuilderUtility.getMaterialForArmourStand(preset, bd.getTardisID(), true);
        ItemStack is = ItemStack.of((Material)dye, (int)1);
        ItemMeta im = is.getItemMeta();
        switch (dye) {
            case BLACK_DYE: {
                im.setItemModel(ChameleonVariant.BLACK_CLOSED.getKey());
                break;
            }
            case RED_DYE: {
                im.setItemModel(ChameleonVariant.RED_CLOSED.getKey());
                break;
            }
            case BROWN_DYE: {
                im.setItemModel(ChameleonVariant.BROWN_CLOSED.getKey());
                break;
            }
            case GREEN_DYE: {
                im.setItemModel(ChameleonVariant.GREEN_CLOSED.getKey());
                break;
            }
            case BLUE_DYE: {
                im.setItemModel(ChameleonVariant.BLUE_CLOSED.getKey());
                break;
            }
            case PURPLE_DYE: {
                im.setItemModel(ChameleonVariant.PURPLE_CLOSED.getKey());
                break;
            }
            case CYAN_DYE: {
                im.setItemModel(ChameleonVariant.CYAN_CLOSED.getKey());
                break;
            }
            case LIGHT_GRAY_DYE: {
                im.setItemModel(ChameleonVariant.LIGHT_GRAY_CLOSED.getKey());
                break;
            }
            case GRAY_DYE: {
                im.setItemModel(ChameleonVariant.GRAY_CLOSED.getKey());
                break;
            }
            case PINK_DYE: {
                im.setItemModel(ChameleonVariant.PINK_CLOSED.getKey());
                break;
            }
            case LIME_DYE: {
                im.setItemModel(ChameleonVariant.LIME_CLOSED.getKey());
                break;
            }
            case YELLOW_DYE: {
                im.setItemModel(ChameleonVariant.YELLOW_CLOSED.getKey());
                break;
            }
            case LIGHT_BLUE_DYE: {
                im.setItemModel(ChameleonVariant.LIGHT_BLUE_CLOSED.getKey());
                break;
            }
            case MAGENTA_DYE: {
                im.setItemModel(ChameleonVariant.MAGENTA_CLOSED.getKey());
                break;
            }
            case ORANGE_DYE: {
                im.setItemModel(ChameleonVariant.ORANGE_CLOSED.getKey());
                break;
            }
            case WHITE_DYE: {
                im.setItemModel(ChameleonVariant.WHITE_CLOSED.getKey());
                break;
            }
            case CYAN_STAINED_GLASS_PANE: {
                im.setItemModel(ChameleonVariant.TENNANT_CLOSED.getKey());
                break;
            }
            case LEATHER_HORSE_ARMOR: {
                im.setItemModel(ColouredVariant.TINTED_CLOSED.getKey());
                break;
            }
            case WOLF_SPAWN_EGG: {
                im.setItemModel(ChameleonVariant.BAD_WOLF_CLOSED.getKey());
                break;
            }
            case ENDER_PEARL: {
                im.setItemModel(ChameleonVariant.PANDORICA_CLOSED.getKey());
                break;
            }
            case GRAY_STAINED_GLASS_PANE: {
                im.setItemModel(ChameleonVariant.WEEPING_ANGEL_CLOSED.getKey());
                break;
            }
            default: {
                im.setItemModel(new NamespacedKey((Plugin)plugin, TARDISBuilderUtility.getCustomModelPath(dye.toString()) + "_closed"));
            }
        }
        if (bd.shouldAddSign() && bd.getPlayer() != null) {
            String pb = "";
            block23 : switch (preset) {
                case WEEPING_ANGEL: {
                    pb = "Weeping Angel";
                    break;
                }
                case PANDORICA: {
                    pb = "Pandorica";
                    break;
                }
                case ITEM: {
                    for (String k : plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
                        if (!plugin.getCustomModelConfig().getString("models." + k + ".item").equals(dye.toString())) continue;
                        pb = k;
                        break block23;
                    }
                    break;
                }
                default: {
                    pb = "Police Box";
                }
            }
            String name = bd.getPlayer().getName() + "'s " + pb;
            TextComponent custom = Component.text((String)name);
            im.displayName((Component)custom);
            stand.customName((Component)custom);
            stand.setCustomNameVisible(true);
        }
        if (preset == ChameleonPreset.COLOURED) {
            ResultSetColour rsc = new ResultSetColour(plugin, bd.getTardisID());
            if (rsc.resultSet()) {
                LeatherArmorMeta leatherArmorMeta = (LeatherArmorMeta)im;
                leatherArmorMeta.setColor(Color.fromRGB((int)rsc.getRed(), (int)rsc.getGreen(), (int)rsc.getBlue()));
                is.setItemMeta((ItemMeta)leatherArmorMeta);
            }
        } else {
            is.setItemMeta(im);
        }
        EntityEquipment ee = stand.getEquipment();
        ee.setHelmet(is, true);
    }

    public static void updateChameleonDemat(String preset, int id) {
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("chameleon_demat", preset);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        TARDIS.plugin.getQueryFactory().doUpdate("tardis", set, where);
    }

    public static String getCustomModelPath(String type) {
        for (String c : TARDIS.plugin.getCustomModelConfig().getConfigurationSection("models").getKeys(false)) {
            if (!type.equals(TARDIS.plugin.getCustomModelConfig().getString("models." + c + ".item"))) continue;
            return TARDISStringUtils.toUnderscoredLowercase(c);
        }
        return "custom";
    }
}

