/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.shell;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonColumn;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Directional;

public class TARDISShellScanner {
    static final int[] eastXsouthZ = new int[]{-1, 0, 1, 1, 1, 0, -1, -1, 0, -2};
    static final int[] northXeastZ = new int[]{-1, -1, -1, 0, 1, 1, 1, 0, 0, 0};
    static final int[] westXnorthZ = new int[]{1, 0, -1, -1, -1, 0, 1, 1, 0, 2};
    static final int[] southXwestZ = new int[]{1, 1, 1, 0, -1, -1, -1, 0, 0, 0};

    public static TARDISChameleonColumn scan(TARDIS plugin, int id, ChameleonPreset preset) {
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(plugin, id);
        if (!rsc.resultSet()) {
            return plugin.getPresets().getColumn(preset, COMPASS.EAST);
        }
        Current current = rsc.getCurrent();
        World w = current.location().getWorld();
        int fx = current.location().getBlockX();
        int fy = current.location().getBlockY();
        int fz = current.location().getBlockZ();
        BlockData[][] shell = new BlockData[10][4];
        for (int c = 0; c < 10; ++c) {
            for (int y = 0; y < 4; ++y) {
                BlockData data = (switch (current.direction()) {
                    case COMPASS.WEST -> w.getBlockAt(fx + westXnorthZ[c], fy + y, fz + southXwestZ[c]);
                    case COMPASS.NORTH -> w.getBlockAt(fx + northXeastZ[c], fy + y, fz + westXnorthZ[c]);
                    case COMPASS.SOUTH -> w.getBlockAt(fx + southXwestZ[c], fy + y, fz + eastXsouthZ[c]);
                    default -> w.getBlockAt(fx + eastXsouthZ[c], fy + y, fz + northXeastZ[c]);
                }).getBlockData();
                if (data instanceof Directional) {
                    Directional directional = (Directional)data;
                    switch (current.direction()) {
                        case WEST: {
                            directional.setFacing(directional.getFacing().getOppositeFace());
                            break;
                        }
                        case NORTH: {
                            BlockFace face = switch (directional.getFacing()) {
                                case BlockFace.EAST -> BlockFace.NORTH;
                                case BlockFace.SOUTH -> BlockFace.EAST;
                                case BlockFace.WEST -> BlockFace.SOUTH;
                                default -> BlockFace.WEST;
                            };
                            directional.setFacing(face);
                            break;
                        }
                        case SOUTH: {
                            BlockFace face = switch (directional.getFacing()) {
                                case BlockFace.EAST -> BlockFace.SOUTH;
                                case BlockFace.SOUTH -> BlockFace.WEST;
                                case BlockFace.WEST -> BlockFace.NORTH;
                                default -> BlockFace.EAST;
                            };
                            directional.setFacing(face);
                            break;
                        }
                    }
                }
                shell[c][y] = data;
            }
        }
        return new TARDISChameleonColumn(shell);
    }
}

