/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.utils;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;

public class TARDISChameleonCircuit {
    private final TARDIS plugin;

    public TARDISChameleonCircuit(TARDIS plugin) {
        this.plugin = plugin;
    }

    public Material getChameleonBlock(Block b, OfflinePlayer p) {
        Material chameleonType = b.getType();
        Material wall_block = Material.LIGHT_GRAY_TERRACOTTA;
        if (this.plugin.getBlocksConfig().getStringList("chameleon_blocks").contains(chameleonType.toString())) {
            wall_block = chameleonType;
        }
        if (TARDISConstants.CHAMELEON_BLOCKS_BAD.contains(chameleonType) && p != null) {
            this.plugin.getMessenger().send((CommandSender)p.getPlayer(), TardisModule.TARDIS, "CHAM_NOT_ENGAGE");
        }
        if (TARDISConstants.CHAMELEON_BLOCKS_CHANGE.contains(chameleonType)) {
            wall_block = TARDISConstants.changeToMaterial(chameleonType);
        }
        if (TARDISConstants.CHAMELEON_BLOCKS_NEXT.contains(chameleonType)) {
            for (BlockFace bf : this.plugin.getGeneralKeeper().getSurrounding()) {
                Block surroundblock = b.getRelative(bf);
                Material emat = surroundblock.getType();
                if (TARDISConstants.CHAMELEON_BLOCKS_VALID.contains(emat)) {
                    wall_block = emat;
                    break;
                }
                if (!TARDISConstants.CHAMELEON_BLOCKS_CHANGE.contains(emat)) continue;
                wall_block = TARDISConstants.changeToMaterial(emat);
                break;
            }
        }
        if (TARDISConstants.CHAMELEON_BLOCKS_PRECIOUS.contains(chameleonType) && !this.plugin.getConfig().getBoolean("allow.all_blocks")) {
            wall_block = switch (chameleonType) {
                case Material.IRON_BLOCK, Material.GOLD_BLOCK -> Material.YELLOW_WOOL;
                case Material.DIAMOND_BLOCK -> Material.LIGHT_BLUE_WOOL;
                case Material.EMERALD_BLOCK -> Material.LIME_WOOL;
                case Material.REDSTONE_BLOCK, Material.TNT -> Material.RED_WOOL;
                case Material.COAL_BLOCK -> Material.BLACK_WOOL;
                case Material.NETHERITE_BLOCK -> Material.BROWN_WOOL;
                default -> Material.BLUE_WOOL;
            };
        }
        return wall_block;
    }
}

