/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.chameleon.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.EnumMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.chameleon.TARDISChameleonPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonColumn;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.files.TARDISFileCopier;
import org.bukkit.command.CommandSender;

public class TARDISCustomPreset {
    private final EnumMap<COMPASS, TARDISChameleonColumn> blueprint = new EnumMap(COMPASS.class);
    private final EnumMap<COMPASS, TARDISChameleonColumn> stained = new EnumMap(COMPASS.class);
    private final EnumMap<COMPASS, TARDISChameleonColumn> glass = new EnumMap(COMPASS.class);
    private String firstLine;
    private String secondLine;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePresets() {
        File custom_file;
        String[] custom_data = new String[6];
        if (!TARDIS.plugin.getConfig().getBoolean("conversions.custom_preset")) {
            custom_file = TARDISFileCopier.copy(String.valueOf(TARDIS.plugin.getDataFolder()) + File.separator + "custom_preset.txt", TARDIS.plugin.getResource("custom_preset.txt"), true);
            TARDIS.plugin.getConfig().set("conversions.custom_preset", (Object)true);
            TARDIS.plugin.saveConfig();
        } else {
            custom_file = TARDIS.plugin.getTardisCopier().copy("custom_preset.txt");
        }
        BufferedReader bufRdr = null;
        int i = 0;
        try {
            String line;
            bufRdr = new BufferedReader(new FileReader(custom_file));
            while ((line = bufRdr.readLine()) != null) {
                if (line.startsWith("#")) continue;
                custom_data[i] = line;
                ++i;
            }
        }
        catch (IOException io) {
            TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "Could not read custom preset file! " + io.getMessage());
        }
        finally {
            if (bufRdr != null) {
                try {
                    bufRdr.close();
                }
                catch (IOException e) {
                    TARDIS.plugin.debug("Error closing custom preset reader! " + e.getMessage());
                }
            }
        }
        for (COMPASS d : COMPASS.values()) {
            this.blueprint.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, custom_data[0]));
            this.stained.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, custom_data[1]));
            this.glass.put(d, TARDISChameleonPreset.buildTARDISChameleonColumn(d, custom_data[2]));
        }
        if (custom_data[3] != null && !custom_data[3].isEmpty()) {
            this.firstLine = custom_data[3];
            this.secondLine = custom_data[4];
        } else {
            this.firstLine = "CUSTOM TEXT";
            this.secondLine = "GOES HERE";
        }
    }

    public EnumMap<COMPASS, TARDISChameleonColumn> getBlueprint() {
        return this.blueprint;
    }

    public EnumMap<COMPASS, TARDISChameleonColumn> getStained() {
        return this.stained;
    }

    public EnumMap<COMPASS, TARDISChameleonColumn> getGlass() {
        return this.glass;
    }

    public String getFirstLine() {
        return this.firstLine;
    }

    public String getSecondLine() {
        return this.secondLine;
    }
}

