/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISBook;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAchievements;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISBookCommands
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final LinkedHashMap<String, String> books;
    private final List<String> ROOT_SUBS;
    private final List<String> DO_SUBS = ImmutableList.of((Object)"get", (Object)"start");

    public TARDISBookCommands(TARDIS plugin) {
        this.plugin = plugin;
        this.books = this.getAchievements();
        this.ROOT_SUBS = ImmutableList.copyOf(this.books.keySet());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisbook")) {
            if (args.length < 1) {
                new TARDISCommandHelper(this.plugin).getCommand("tardisbook", sender);
                return true;
            }
            if (TARDISPermission.hasPermission(sender, "tardis.book")) {
                String first = args[0].toLowerCase(Locale.ROOT);
                if (first.equals("list")) {
                    int b = 1;
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "BOOK_RASS");
                    if (!this.books.isEmpty()) {
                        for (Map.Entry<String, String> entry : this.books.entrySet()) {
                            sender.sendMessage(b + ". [" + entry.getKey() + "] - " + entry.getValue());
                            ++b;
                        }
                    } else {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "BOOK_NONE");
                    }
                    return true;
                }
                Player player = null;
                if (sender instanceof Player) {
                    player = (Player)sender;
                }
                if (player == null) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                    return true;
                }
                if (args.length < 2) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BOOK_NEED");
                    return false;
                }
                if (!this.books.containsKey(first)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BOOK_NOT_FOUND");
                    return true;
                }
                String second = args[1].toLowerCase(Locale.ROOT);
                if (second.equals("get")) {
                    TARDISBook book = new TARDISBook(this.plugin);
                    book.writeBook(this.books.get(first), "Rassilon", first, player);
                    return true;
                }
                if (second.equals("start")) {
                    if (this.plugin.getAchievementConfig().getBoolean(first + ".auto")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ACHIEVE_AUTO");
                        return true;
                    }
                    HashMap<String, Object> where = new HashMap<String, Object>();
                    where.put("uuid", player.getUniqueId().toString());
                    where.put("name", first);
                    ResultSetAchievements rsa = new ResultSetAchievements(this.plugin, where);
                    if (rsa.resultSet()) {
                        if (rsa.isCompleted()) {
                            if (!this.plugin.getAchievementConfig().getBoolean(first + ".repeatable")) {
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ACHIEVE_ONCE");
                                return true;
                            }
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ACHIEVE_ALREADY_STARTED");
                            return true;
                        }
                    }
                    HashMap<String, Object> set = new HashMap<String, Object>();
                    set.put("uuid", player.getUniqueId().toString());
                    set.put("name", first);
                    this.plugin.getQueryFactory().doInsert("achievements", set);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ACHIEVE_STARTED", first);
                    return true;
                }
            }
        }
        return false;
    }

    private LinkedHashMap<String, String> getAchievements() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Set aset = this.plugin.getAchievementConfig().getRoot().getKeys(false);
        aset.forEach(a -> {
            if (this.plugin.getAchievementConfig().getBoolean(a + ".enabled")) {
                String title_reward = this.plugin.getAchievementConfig().getString(a + ".name") + " - " + this.plugin.getAchievementConfig().getString(a + ".reward_type") + ":" + this.plugin.getAchievementConfig().getString(a + ".reward_amount");
                map.put((String)a, title_reward);
            }
        });
        return map;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], this.ROOT_SUBS);
        }
        if (args.length == 2) {
            return this.partial(lastArg, this.DO_SUBS);
        }
        return ImmutableList.of();
    }
}

