/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.config;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Config;
import me.eccentric_nz.TARDIS.utility.protection.TARDISWorldGuardFlag;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISConfigTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final TARDIS plugin;
    private final ImmutableList<String> ROOT_SUBS;
    private final ImmutableList<String> BOOL_SUBS = ImmutableList.of((Object)"true", (Object)"false");
    private final ImmutableList<String> COLOURS = ImmutableList.of((Object)"AQUA", (Object)"BLACK", (Object)"BLUE", (Object)"DARK_AQUA", (Object)"DARK_BLUE", (Object)"DARK_GRAY", (Object)"DARK_GREEN", (Object)"DARK_PURPLE", (Object)"DARK_RED", (Object)"GOLD", (Object)"GRAY", (Object)"GREEN", (Object[])new String[]{"LIGHT_PURPLE", "RED", "WHITE", "YELLOW"});
    private final List<String> CONFIG_SUBS = new ArrayList<String>();
    private final ImmutableList<String> DB_SUBS = ImmutableList.of((Object)"mysql", (Object)"sqlite");
    private final ImmutableList<String> MAPPING_SUBS = ImmutableList.of((Object)"dynmap", (Object)"BlueMap", (Object)"squaremap");
    private final ImmutableList<String> CRAFTING_SUBS = ImmutableList.of((Object)"easy", (Object)"hard");
    private final List<String> FILE_SUBS = new ArrayList<String>();
    private final ImmutableList<String> FLAG_SUBS;
    private final ImmutableList<String> KEYS = ImmutableList.of((Object)"first", (Object)"second", (Object)"third", (Object)"fifth", (Object)"seventh", (Object)"ninth", (Object)"tenth", (Object)"eleventh", (Object)"susan", (Object)"rose", (Object)"sally", (Object)"perception", (Object[])new String[]{"gold"});
    private final ImmutableList<String> LANG_SUBS = ImmutableList.of((Object)"ar", (Object)"bg", (Object)"ca", (Object)"zh", (Object)"cs", (Object)"da", (Object)"nl", (Object)"en", (Object)"et", (Object)"fi", (Object)"fr", (Object)"de", (Object[])new String[]{"el", "ht", "he", "hi", "mww", "hu", "id", "it", "ja", "ko", "lv", "lt", "ms", "no", "fa", "pl", "pt", "ro", "ru", "sk", "sl", "es", "sv", "th", "tr", "uk", "ur", "vi"});
    private final List<String> PRESETS = new ArrayList<String>();
    private final ImmutableList<String> REGION_SUBS = ImmutableList.of((Object)"entry", (Object)"exit");
    private final ImmutableList<String> SIEGE_SUBS = ImmutableList.of((Object)"enabled", (Object)"breeding", (Object)"growth", (Object)"butcher", (Object)"creeper", (Object)"healing", (Object)"texture", (Object)"true", (Object)"false");
    private final ImmutableList<String> SONICS = ImmutableList.of((Object)"mark_1", (Object)"mark_2", (Object)"mark_3", (Object)"mark_4", (Object)"eighth", (Object)"ninth", (Object)"tenth", (Object)"eleventh", (Object)"twelfth", (Object)"thirteenth", (Object)"fourteenth", (Object)"fifteenth", (Object[])new String[]{"master", "umbrella", "sonic_probe", "sarah_jane", "rani", "river_song", "war"});
    private final ImmutableList<String> TIPS_NEXT_SUBS = ImmutableList.of((Object)"FREE", (Object)"HIGHEST");
    private final ImmutableList<String> TIPS_SUBS = ImmutableList.of((Object)"400", (Object)"800", (Object)"1200", (Object)"1600");
    private final ImmutableList<String> TOWNY_SUBS = ImmutableList.of((Object)"none", (Object)"wilderness", (Object)"town", (Object)"nation");
    private final ImmutableList<String> USE_CLAY_SUBS = ImmutableList.of((Object)"WOOL", (Object)"TERRACOTTA", (Object)"CONCRETE");
    private final ImmutableList<String> VORTEX_SUBS = ImmutableList.of((Object)"kill", (Object)"teleport");
    private final List<String> WORLD_SUBS = new ArrayList<String>();

    public TARDISConfigTabComplete(TARDIS plugin) {
        this.plugin = plugin;
        this.ROOT_SUBS = ImmutableList.copyOf(this.combineLists());
        this.FLAG_SUBS = plugin.isWorldGuardOnServer() ? ImmutableList.copyOf(TARDISWorldGuardFlag.getFLAG_LOOKUP().keySet()) : ImmutableList.of((Object)"none", (Object)"build", (Object)"entry");
        for (ChameleonPreset chameleonPreset : ChameleonPreset.values()) {
            this.PRESETS.add(chameleonPreset.toString());
        }
        for (Enum enum_ : Config.values()) {
            this.FILE_SUBS.add(enum_.toString());
        }
        plugin.getServer().getWorlds().forEach(w -> this.WORLD_SUBS.add(w.getName()));
        this.CONFIG_SUBS.addAll(this.plugin.getConfig().getDefaultSection().getKeys(false));
        this.CONFIG_SUBS.remove("debug");
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 2) {
            String sub;
            return switch (sub = args[0]) {
                case "include", "exclude" -> this.partial(lastArg, this.WORLD_SUBS);
                case "options" -> this.partial(lastArg, this.CONFIG_SUBS);
                case "crafting" -> this.partial(lastArg, (Collection<String>)this.CRAFTING_SUBS);
                case "provider" -> this.partial(lastArg, (Collection<String>)this.MAPPING_SUBS);
                case "respect_towny" -> this.partial(lastArg, (Collection<String>)this.TOWNY_SUBS);
                case "respect_worldguard" -> this.partial(lastArg, (Collection<String>)this.FLAG_SUBS);
                case "region_flag" -> this.partial(lastArg, (Collection<String>)this.REGION_SUBS);
                case "reload" -> this.partial(lastArg, this.FILE_SUBS);
                case "vortex_fall" -> this.partial(lastArg, (Collection<String>)this.VORTEX_SUBS);
                case "tips_next" -> this.partial(lastArg, (Collection<String>)this.TIPS_NEXT_SUBS);
                case "sign_colour" -> this.partial(lastArg, (Collection<String>)this.COLOURS);
                case "siege" -> this.partial(lastArg, (Collection<String>)this.SIEGE_SUBS);
                case "default_key" -> this.partial(lastArg, (Collection<String>)this.KEYS);
                case "default_preset" -> this.partial(lastArg, this.PRESETS);
                case "default_model" -> this.partial(lastArg, (Collection<String>)this.SONICS);
                case "database" -> this.partial(lastArg, (Collection<String>)this.DB_SUBS);
                case "language" -> this.partial(lastArg, (Collection<String>)this.LANG_SUBS);
                case "tips_limit" -> this.partial(lastArg, (Collection<String>)this.TIPS_SUBS);
                case "use_clay" -> this.partial(lastArg, (Collection<String>)this.USE_CLAY_SUBS);
                default -> this.partial(lastArg, (Collection<String>)this.BOOL_SUBS);
            };
        }
        return ImmutableList.of();
    }

    private List<String> combineLists() {
        ArrayList<String> newList = new ArrayList<String>(this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsStr.size() + this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsBool.size() + this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsInt.size() + this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsStrArtron.size() + this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsIntArtron.size());
        newList.addAll(this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsStr.keySet());
        newList.addAll(this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsBool.keySet());
        newList.addAll(this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsInt.keySet());
        newList.addAll(this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsStrArtron);
        newList.addAll(this.plugin.getGeneralKeeper().getTardisConfigCommand().firstsIntArtron);
        return newList;
    }
}

