/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Slab;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class ZeroCommand {
    private final Slab slab = (Slab)Material.STONE_BRICK_SLAB.createBlockData();
    private final List<Vector> vectors = List.of(new Vector(9, 0, 3), new Vector(11, 0, 4), new Vector(12, 1, 5), new Vector(13, 1, 7), new Vector(13, 2, 9), new Vector(12, 2, 11), new Vector(11, 3, 12), new Vector(9, 3, 13), new Vector(7, 4, 13), new Vector(5, 4, 12), new Vector(4, 5, 11), new Vector(3, 5, 9), new Vector(3, 6, 7), new Vector(4, 6, 5), new Vector(5, 7, 4), new Vector(7, 7, 3), new Vector(9, 8, 3), new Vector(11, 8, 4), new Vector(12, 9, 5), new Vector(13, 9, 7), new Vector(13, 10, 9), new Vector(12, 10, 11), new Vector(11, 11, 12), new Vector(9, 11, 13), new Vector(7, 12, 13), new Vector(5, 12, 12), new Vector(4, 13, 11), new Vector(3, 13, 9), new Vector(3, 14, 7), new Vector(4, 14, 5), new Vector(5, 15, 4), new Vector(7, 15, 3));

    public boolean spiral(Player player) {
        Location location = player.getLocation().clone();
        Chunk chunk = location.getChunk();
        int x = chunk.getX() * 16;
        int z = chunk.getZ() * 16;
        int y = location.getBlockY();
        Block block = location.getWorld().getBlockAt(x, y, z);
        this.walls(block.getLocation().clone().add(8.0, 0.0, 8.0));
        this.build(block.getLocation().add(0.5, 0.0, 0.5));
        return true;
    }

    private void build(Location location) {
        for (int i = 0; i < 32; ++i) {
            Vector v = this.vectors.get(i);
            location.add(v.getX(), v.getY(), v.getZ());
            this.threeByThree(location.getBlock(), i);
            location.subtract(v.getX(), v.getY(), v.getZ());
        }
    }

    private void threeByThree(Block block, int i) {
        this.slab.setType(i % 2 == 1 ? Slab.Type.TOP : Slab.Type.BOTTOM);
        block.setBlockData((BlockData)this.slab);
        for (BlockFace face : TARDIS.plugin.getGeneralKeeper().getSurrounding()) {
            this.slab.setType(i % 2 == 1 ? Slab.Type.TOP : Slab.Type.BOTTOM);
            if (!block.getRelative(face).getType().isAir()) {
                this.slab.setType(Slab.Type.DOUBLE);
            }
            block.getRelative(face).setBlockData((BlockData)this.slab);
        }
    }

    private void walls(Location loc) {
        int z;
        int x;
        int y;
        for (y = 0; y < 16; ++y) {
            for (x = -7; x < 8; ++x) {
                for (z = -7; z < 8; ++z) {
                    loc.add((double)x, (double)y, (double)z);
                    if (x == 0 || z == 0) {
                        loc.getBlock().setType(y == 5 ? Material.BLACK_TERRACOTTA : Material.ORANGE_TERRACOTTA);
                    } else {
                        loc.getBlock().setType(Material.PURPLE_TERRACOTTA);
                    }
                    loc.subtract((double)x, (double)y, (double)z);
                }
            }
        }
        for (y = 0; y < 16; ++y) {
            for (x = -6; x < 7; ++x) {
                for (z = -6; z < 7; ++z) {
                    loc.add((double)x, (double)y, (double)z);
                    loc.getBlock().setType(Material.AIR);
                    loc.subtract((double)x, (double)y, (double)z);
                }
            }
        }
    }
}

