/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.preferences;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.commands.preferences.TARDISPrefsCommands;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.particles.ParticleEffect;
import me.eccentric_nz.TARDIS.particles.ParticleShape;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import me.eccentric_nz.TARDIS.universaltranslator.Language;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;

public class TARDISPrefsTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final ImmutableList<String> ROOT_SUBS = TARDISPrefsCommands.getRootArgs();
    private final List<String> EFFECT_SUBS = new ArrayList<String>();
    private final List<String> SHAPE_SUBS = new ArrayList<String>();
    private final ImmutableList<String> ONOFF_SUBS = ImmutableList.of((Object)"on", (Object)"off");
    private final ImmutableList<String> HADS_SUBS = ImmutableList.of((Object)"DISPLACEMENT", (Object)"DISPERSAL");
    private final ImmutableList<String> HUM_SUBS = ImmutableList.of((Object)"alien", (Object)"atmosphere", (Object)"computer", (Object)"copper", (Object)"coral", (Object)"galaxy", (Object)"learning", (Object)"mind", (Object)"neon", (Object)"sleeping", (Object)"void", (Object)"random", (Object[])new String[0]);
    private final ImmutableList<String> FLIGHT_SUBS = ImmutableList.of((Object)"normal", (Object)"regulator", (Object)"manual", (Object)"exterior");
    private final ImmutableList<String> KEY_SUBS;
    private final List<String> LIGHT_SUBS = new ArrayList<String>();
    private final ImmutableList<String> MAT_SUBS;
    private final List<String> LANGUAGE_SUBS = new ArrayList<String>();

    /*
     * WARNING - void declaration
     */
    public TARDISPrefsTabComplete(TARDIS plugin) {
        ArrayList mats = new ArrayList();
        TARDISWalls.BLOCKS.forEach(key -> mats.add(key.toString()));
        for (Language language : Language.values()) {
            this.LANGUAGE_SUBS.add(language.toString());
        }
        for (Enum enum_ : TardisLight.values()) {
            this.LIGHT_SUBS.add(enum_.toString());
        }
        this.MAT_SUBS = ImmutableList.copyOf(mats);
        if (plugin.getConfig().getBoolean("travel.give_key") && !plugin.getConfig().getBoolean("allow.all_blocks")) {
            this.KEY_SUBS = ImmutableList.copyOf((Collection)plugin.getBlocksConfig().getStringList("keys"));
        } else {
            void var6_12;
            ArrayList<String> keys = new ArrayList<String>();
            Material[] materialArray = Material.values();
            int n = materialArray.length;
            boolean bl = false;
            while (var6_12 < n) {
                Material key2 = materialArray[var6_12];
                if (!key2.isBlock()) {
                    keys.add(key2.toString());
                }
                ++var6_12;
            }
            this.KEY_SUBS = ImmutableList.copyOf(keys);
        }
        for (Enum enum_ : ParticleEffect.values()) {
            this.EFFECT_SUBS.add(enum_.toString());
        }
        for (Enum enum_ : ParticleShape.values()) {
            this.SHAPE_SUBS.add(enum_.toString());
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 2) {
            String sub;
            return switch (sub = args[0]) {
                case "add", "remove" -> null;
                case "floor", "wall", "siege_floor", "siege_wall" -> this.partial(lastArg, (Collection<String>)this.MAT_SUBS);
                case "key" -> this.partial(lastArg, (Collection<String>)this.KEY_SUBS);
                case "language", "translate" -> this.partial(lastArg, this.LANGUAGE_SUBS);
                case "flight" -> this.partial(lastArg, (Collection<String>)this.FLIGHT_SUBS);
                case "hads_type" -> this.partial(lastArg, (Collection<String>)this.HADS_SUBS);
                case "hum" -> this.partial(lastArg, (Collection<String>)this.HUM_SUBS);
                case "lights" -> this.partial(lastArg, this.LIGHT_SUBS);
                case "effect" -> this.partial(lastArg, this.EFFECT_SUBS);
                case "shape" -> this.partial(lastArg, this.SHAPE_SUBS);
                default -> this.partial(lastArg, (Collection<String>)this.ONOFF_SUBS);
            };
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("translate")) {
            return this.partial(lastArg, this.LANGUAGE_SUBS);
        }
        if (args.length == 4 && args[0].equalsIgnoreCase("translate")) {
            return null;
        }
        return ImmutableList.of();
    }
}

