/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.remote;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.TARDISEmergencyRelocation;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetNextLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.BlockCommandSender;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

class TARDISRemoteTravelCommand {
    private final TARDIS plugin;

    TARDISRemoteTravelCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean doTravel(int id, OfflinePlayer player, CommandSender sender) {
        HashMap<String, Object> wherei = new HashMap<String, Object>();
        wherei.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherei, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
            if (!rsc.resultSet()) {
                new TARDISEmergencyRelocation(this.plugin).relocate(id, player.getPlayer());
                return true;
            }
            Current current = rsc.getCurrent();
            String resetw = current.location().getWorld().getName();
            ResultSetNextLocation rsn = new ResultSetNextLocation(this.plugin, id);
            if (!rsn.resultSet() && !(sender instanceof BlockCommandSender)) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "DEST_NO_LOAD");
                return true;
            }
            boolean is_next_sub = rsn.isSubmarine();
            Location exit = new Location(rsn.getWorld(), (double)rsn.getX(), (double)rsn.getY(), (double)rsn.getZ());
            COMPASS sd = rsn.getDirection();
            if (!exit.getWorld().isChunkLoaded(exit.getChunk())) {
                exit.getWorld().loadChunk(exit.getChunk());
            }
            HashMap<String, Object> set = new HashMap<String, Object>();
            if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                this.plugin.getTrackerKeeper().getInVortex().add(id);
                DestroyData dd = new DestroyData();
                dd.setDirection(current.direction());
                dd.setLocation(current.location());
                dd.setPlayer(player);
                dd.setHide(false);
                dd.setOutside(false);
                dd.setSubmarine(current.submarine());
                dd.setTardisID(id);
                dd.setThrottle(SpaceTimeThrottle.NORMAL);
                if (!tardis.isHidden() && !this.plugin.getTrackerKeeper().getResetWorlds().contains(resetw)) {
                    this.plugin.getTrackerKeeper().getDematerialising().add(id);
                    this.plugin.getPresetDestroyer().destroyPreset(dd);
                } else {
                    set.put("hidden", 0);
                    this.plugin.getPresetDestroyer().removeBlockProtection(id);
                }
            }
            long delay = this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id) ? 1L : 500L;
            BuildData bd = new BuildData(player.getUniqueId().toString());
            bd.setDirection(sd);
            bd.setLocation(exit);
            bd.setMalfunction(false);
            bd.setOutside(false);
            bd.setPlayer(player);
            bd.setRebuild(false);
            bd.setSubmarine(is_next_sub);
            bd.setTardisID(id);
            bd.setThrottle(SpaceTimeThrottle.NORMAL);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.plugin.getPresetBuilder().buildPreset(bd);
                TARDISSounds.playTARDISSound(bd.getLocation(), "tardis_land");
            }, delay);
            this.plugin.getTrackerKeeper().getHadsDamage().remove(id);
            HashMap<String, Object> setcurrent = new HashMap<String, Object>();
            setcurrent.put("world", exit.getWorld().getName());
            setcurrent.put("x", exit.getBlockX());
            setcurrent.put("y", exit.getBlockY());
            setcurrent.put("z", exit.getBlockZ());
            setcurrent.put("direction", sd.toString());
            setcurrent.put("submarine", is_next_sub ? 1 : 0);
            HashMap<String, Object> wherecurrent = new HashMap<String, Object>();
            wherecurrent.put("tardis_id", id);
            HashMap<String, Object> setback = new HashMap<String, Object>();
            if (current == null) {
                setback.put("world", exit.getWorld().getName());
                setback.put("x", exit.getX());
                setback.put("y", exit.getY());
                setback.put("z", exit.getZ());
                setback.put("direction", exit.getDirection().toString());
                setback.put("submarine", is_next_sub ? 1 : 0);
            } else {
                setback.put("world", current.location().getWorld().getName());
                setback.put("x", current.location().getBlockX());
                setback.put("y", current.location().getBlockY());
                setback.put("z", current.location().getBlockZ());
                setback.put("direction", current.direction().toString());
                setback.put("submarine", current.submarine() ? 1 : 0);
            }
            HashMap<String, Object> whereback = new HashMap<String, Object>();
            whereback.put("tardis_id", id);
            HashMap<String, Object> setdoor = new HashMap<String, Object>();
            setdoor.put("door_direction", sd.toString());
            HashMap<String, Object> wheredoor = new HashMap<String, Object>();
            wheredoor.put("tardis_id", id);
            wheredoor.put("door_type", 0);
            HashMap<String, Object> whereh = new HashMap<String, Object>();
            whereh.put("tardis_id", id);
            if (!set.isEmpty()) {
                this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
            }
            this.plugin.getQueryFactory().doUpdate("current", setcurrent, wherecurrent);
            this.plugin.getQueryFactory().doUpdate("back", setback, whereback);
            this.plugin.getQueryFactory().doUpdate("doors", setdoor, wheredoor);
            return true;
        }
        return false;
    }
}

