/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISDiskWriterCommand;
import me.eccentric_nz.TARDIS.arch.TARDISArchCommand;
import me.eccentric_nz.TARDIS.chatGUI.TARDISUpdateChatGUI;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISARSRemoveCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISAbandonCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISAbortCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISAddCompanionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISArchiveCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISBellCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISCheckLocCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISColouriseCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISComehereCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISConstructCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISCubeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISDecommissionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISDirectionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISDoorCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISEjectCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISEmergencyProgrammeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISExciteCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISExterminateCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISFindCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISHandbrakeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISHelpCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISHideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISInsideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISItemCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISJettisonCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISLampsCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISListCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISMakeHerBlueCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISMonstersCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISNameKeyCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISOccupyCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISPlayThemeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRebuildCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRemoveCompanionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRemoveSavedLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRenameSavedLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISReorderSavedLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRescueCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRoomCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISSaveIconCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISSaveLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISSecondaryCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISSetDestinationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISSetHomeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISStopSoundCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISTagCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISTransmatCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISUpdateCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISUpgradeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISVersionCommand;
import me.eccentric_nz.TARDIS.commands.utils.TARDISAcceptor;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisCommand;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.ComehereAction;
import me.eccentric_nz.TARDIS.travel.ComehereRequest;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TARDISCommands
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISCommands(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardis")) {
            TardisCommand tc;
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (args.length == 0) {
                new TARDISCommandHelper(this.plugin).getCommand("", sender);
                return true;
            }
            String first = args[0].toLowerCase(Locale.ROOT);
            try {
                tc = TardisCommand.valueOf(first);
            }
            catch (IllegalArgumentException e) {
                if (first.equals("call")) {
                    UUID chatter = player.getUniqueId();
                    if (this.plugin.getTrackerKeeper().getComehereRequests().containsKey(chatter)) {
                        ComehereRequest request = this.plugin.getTrackerKeeper().getComehereRequests().get(chatter);
                        new ComehereAction(this.plugin).doTravel(request);
                        this.plugin.getTrackerKeeper().getComehereRequests().remove(chatter);
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "REQUEST_TIMEOUT");
                    }
                } else if (first.equals("request")) {
                    new TARDISAcceptor(this.plugin).doRequest(player, true);
                } else {
                    this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "That command wasn't recognised type '/tardis help' to see the commands");
                    return false;
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("version")) {
                return new TARDISVersionCommand(this.plugin).displayVersion(sender);
            }
            if (args[0].equalsIgnoreCase("help")) {
                return new TARDISHelpCommand(this.plugin).showHelp(sender, args);
            }
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                return false;
            }
            if (args[0].equalsIgnoreCase("stop_sound")) {
                return new TARDISStopSoundCommand(this.plugin).mute(player);
            }
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(rs.getTardisId()) && tc.noSiege()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CMD");
                return true;
            }
            switch (tc) {
                case abandon: {
                    return new TARDISAbandonCommand(this.plugin).doAbandon(sender, args.length > 1);
                }
                case add: {
                    if (args.length == 1) {
                        return new TARDISAddCompanionCommand(this.plugin).doAddGUI(player);
                    }
                    return new TARDISAddCompanionCommand(this.plugin).doAdd(player, args);
                }
                case arch_time: {
                    return new TARDISArchCommand(this.plugin).getTime(player);
                }
                case archive: {
                    return new TARDISArchiveCommand(this.plugin).zip(player, args);
                }
                case arsremove: {
                    return new TARDISARSRemoveCommand(this.plugin).resetARS(player);
                }
                case bell: {
                    return new TARDISBellCommand(this.plugin).toggle(rs.getTardisId(), player, args);
                }
                case check_loc: {
                    return new TARDISCheckLocCommand(this.plugin).doACheckLocation(player);
                }
                case colourise: 
                case colorize: {
                    return new TARDISColouriseCommand(this.plugin).updateBeaconGlass(player);
                }
                case comehere: {
                    return new TARDISComehereCommand(this.plugin).doComeHere(player);
                }
                case construct: {
                    return new TARDISConstructCommand(this.plugin).setLine(player, args);
                }
                case cube: {
                    return new TARDISCubeCommand(this.plugin).whoHasCube(player);
                }
                case desktop: 
                case upgrade: 
                case theme: {
                    return new TARDISUpgradeCommand(this.plugin).openUpgradeGUI(player);
                }
                case direction: {
                    return new TARDISDirectionCommand(this.plugin).changeDirection(player, args);
                }
                case door: {
                    return new TARDISDoorCommand(this.plugin).toggleDoors(player, args);
                }
                case egg: {
                    return new TARDISPlayThemeCommand(this.plugin).playTheme(player, args);
                }
                case eject: {
                    return new TARDISEjectCommand(this.plugin).eject(player);
                }
                case excite: {
                    return new TARDISExciteCommand(this.plugin).excite(player);
                }
                case ep1: {
                    return new TARDISEmergencyProgrammeCommand(this.plugin).showEP1(player);
                }
                case erase: {
                    return new TARDISDiskWriterCommand(this.plugin).eraseDisk(player);
                }
                case find: {
                    return new TARDISFindCommand(this.plugin).findTARDIS(player);
                }
                case handbrake: {
                    return new TARDISHandbrakeCommand(this.plugin).toggle(player, rs.getTardisId(), args, false);
                }
                case hide: {
                    return new TARDISHideCommand(this.plugin).hide((OfflinePlayer)player);
                }
                case sethome: {
                    return new TARDISSetHomeCommand(this.plugin).setHome(player, args);
                }
                case inside: {
                    return new TARDISInsideCommand(this.plugin).whosInside(player);
                }
                case item: {
                    return new TARDISItemCommand(this.plugin).update(player, args);
                }
                case jettison: {
                    return new TARDISJettisonCommand(this.plugin).startJettison(player, args);
                }
                case lamps: {
                    return new TARDISLampsCommand(this.plugin).addLampBlocks(player);
                }
                case list: {
                    return new TARDISListCommand(this.plugin).doList(player, args);
                }
                case make_her_blue: {
                    return new TARDISMakeHerBlueCommand(this.plugin).show(player);
                }
                case monsters: {
                    return new TARDISMonstersCommand(this.plugin).reset(player, rs.getTardisId(), args);
                }
                case namekey: {
                    return new TARDISNameKeyCommand(this.plugin).nameKey(player, args);
                }
                case occupy: {
                    return new TARDISOccupyCommand(this.plugin).toggleOccupancy(player, args);
                }
                case decommission: {
                    return new TARDISDecommissionCommand(this.plugin).withdraw(player, args);
                }
                case rebuild: {
                    return new TARDISRebuildCommand(this.plugin).rebuildPreset((OfflinePlayer)player);
                }
                case remove: {
                    return new TARDISRemoveCompanionCommand(this.plugin).doRemoveCompanion(player, args);
                }
                case removesave: {
                    return new TARDISRemoveSavedLocationCommand(this.plugin).doRemoveSave(player, args);
                }
                case renamesave: {
                    return new TARDISRenameSavedLocationCommand(this.plugin).doRenameSave(player, args);
                }
                case reordersave: {
                    return new TARDISReorderSavedLocationCommand(this.plugin).doReorderSave(player, args);
                }
                case rescue: {
                    return new TARDISRescueCommand(this.plugin).startRescue(player, args);
                }
                case room: {
                    return new TARDISRoomCommand(this.plugin).startRoom(player, args);
                }
                case save_player: {
                    ItemStack is = player.getInventory().getItemInMainHand();
                    if (this.heldDiskIsWrong(is, "Player Storage Disk")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_HAND_PLAYER");
                        return true;
                    }
                    return new TARDISDiskWriterCommand(this.plugin).writePlayer(player, args);
                }
                case secondary: {
                    return new TARDISSecondaryCommand(this.plugin).startSecondary(player, args);
                }
                case section: {
                    return new TARDISUpdateChatGUI(this.plugin).showInterface(player, args);
                }
                case setdest: {
                    return new TARDISSetDestinationCommand(this.plugin).doSetDestination(player, args);
                }
                case tagtheood: {
                    return new TARDISTagCommand(this.plugin).getStats(player);
                }
                case transmat: {
                    return new TARDISTransmatCommand(this.plugin).teleportOrProcess(player, args);
                }
                case update: {
                    return new TARDISUpdateCommand(this.plugin).startUpdate(player, args);
                }
                case abort: {
                    return new TARDISAbortCommand(this.plugin).doAbort(player, args, rs.getTardisId());
                }
                case exterminate: {
                    boolean messagePlayer = args.length != 2 || !args[1].equals("6z@3=V!Q7*/O_OB^");
                    return new TARDISExterminateCommand(this.plugin).doExterminate(player, messagePlayer);
                }
                case save: {
                    if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.SAVES)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                        return true;
                    }
                    ItemStack itemStack = player.getInventory().getItemInMainHand();
                    if (itemStack.getType().equals((Object)Material.MUSIC_DISC_FAR)) {
                        return new TARDISDiskWriterCommand(this.plugin).writeSaveToControlDisk(player, args);
                    }
                    if (this.plugin.getConfig().getBoolean("difficulty.disks") && !this.plugin.getUtils().inGracePeriod(player, true)) {
                        if (this.plugin.getConfig().getBoolean("difficulty.disk_in_hand_for_write") && this.heldDiskIsWrong(itemStack, "Save Storage Disk")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_HAND_SAVE");
                            return true;
                        }
                        return new TARDISDiskWriterCommand(this.plugin).writeSave(player, args);
                    }
                    return new TARDISSaveLocationCommand(this.plugin).doSave(player, args);
                }
                case saveicon: {
                    return new TARDISSaveIconCommand(this.plugin).changeIcon((CommandSender)player, args);
                }
            }
        }
        return false;
    }

    private boolean heldDiskIsWrong(ItemStack is, String dn) {
        boolean complexBool = false;
        if (is == null) {
            complexBool = true;
        } else if (!is.hasItemMeta()) {
            complexBool = true;
        } else if (!is.getItemMeta().hasDisplayName()) {
            complexBool = true;
        } else if (!ComponentUtils.endsWith(is.getItemMeta().displayName(), dn)) {
            complexBool = true;
        }
        return complexBool;
    }
}

