/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISMushroomFixerCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final List<String> SUBS = List.of("red", "brown", "stem");

    public TARDISMushroomFixerCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (cmd.getName().equalsIgnoreCase("tardismushroom")) {
                int radius;
                if (!player.hasPermission("tardis.mushroom")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                    return true;
                }
                if (args.length < 2) {
                    return false;
                }
                String type = args[0].toLowerCase(Locale.ROOT);
                if (!this.SUBS.contains(type)) {
                    return false;
                }
                try {
                    radius = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                BlockData data = switch (type) {
                    case "red" -> Material.RED_MUSHROOM_BLOCK.createBlockData();
                    case "brown" -> Material.BROWN_MUSHROOM_BLOCK.createBlockData();
                    default -> Material.MUSHROOM_STEM.createBlockData();
                };
                Block block = player.getLocation().add((double)(-radius), (double)(-radius), (double)(-radius)).getBlock();
                World world = block.getWorld();
                int sx = block.getX();
                int sy = block.getY();
                int sz = block.getZ();
                int diameter = radius * 2;
                for (int x = sx; x < sx + diameter; ++x) {
                    for (int y = sy; y < sy + diameter; ++y) {
                        for (int z = sz; z < sz + diameter; ++z) {
                            Block mushroom = world.getBlockAt(x, y, z);
                            Material material = mushroom.getType();
                            if (material != data.getMaterial()) continue;
                            mushroom.setBlockData(data, false);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(lastArg, this.SUBS);
        }
        return null;
    }
}

