/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.console.models.HelmicRegulatorModel;
import me.eccentric_nz.TARDIS.database.InteractionStateSaver;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;

public class HelmicRegulatorInteraction {
    private final TARDIS plugin;

    public HelmicRegulatorInteraction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void selectWorld(int state, int id, Player player, Interaction interaction) {
        UUID uuid = player.getUniqueId();
        if (this.plugin.getTrackerKeeper().getFlight().containsKey(uuid)) {
            if (interaction.getLocation().toString().equals(this.plugin.getTrackerKeeper().getFlight().get(uuid))) {
                this.plugin.getTrackerKeeper().getCount().put(uuid, this.plugin.getTrackerKeeper().getCount().getOrDefault(uuid, 0) + 1);
            }
            this.plugin.getTrackerKeeper().getFlight().remove(uuid);
        } else {
            World world;
            int next = state + 1;
            if (next > 8 || player.isSneaking()) {
                next = 0;
            }
            String which = "OFF";
            if (next > 0) {
                which = this.getWorldFromState(next);
            }
            if (which.equals("OFF")) {
                next = 0;
            } else if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && (world = this.plugin.getServer().getWorld(which)) != null && (world.getEnvironment() == World.Environment.NETHER || world.getEnvironment() == World.Environment.THE_END) && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.INTER_DIMENSIONAL_TRAVEL)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Inter Dimensional Travel");
                next = 0;
            }
            this.plugin.getMessenger().announceRepeater(player, which);
            new InteractionStateSaver(this.plugin).write("HELMIC_REGULATOR", next, id);
            UUID model = (UUID)interaction.getPersistentDataContainer().get(this.plugin.getModelUuidKey(), this.plugin.getPersistentDataTypeUUID());
            if (model != null) {
                ItemDisplay display = (ItemDisplay)this.plugin.getServer().getEntity(model);
                new HelmicRegulatorModel().setState(display, next);
            }
        }
    }

    private String getWorldFromState(int state) {
        for (String w : this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false)) {
            if (!this.plugin.getPlanetsConfig().getBoolean("planets." + w + ".time_travel") || this.plugin.getPlanetsConfig().getInt("planets." + w + ".helmic_regulator_order") != state) continue;
            return w;
        }
        return "OFF";
    }
}

