/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.interaction;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronLeveID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.Transformation;
import org.joml.Vector3f;

public class SonicConsoleRecharge
implements Runnable {
    private final TARDIS plugin;
    private final UUID display_uuid;
    private final Interaction interaction;
    private final int id;
    private final Player player;
    private final int full;
    private final int amount;
    private final Transformation transformation = new Transformation(TARDISConstants.VECTOR_ZERO, TARDISConstants.AXIS_ANGLE_ZERO, new Vector3f(0.33f, 0.33f, 0.33f), TARDISConstants.AXIS_ANGLE_ZERO);
    private TextDisplay text;
    private int task;

    public SonicConsoleRecharge(TARDIS plugin, UUID display_uuid, Interaction interaction, int id, Player player) {
        this.plugin = plugin;
        this.display_uuid = display_uuid;
        this.interaction = interaction;
        this.id = id;
        this.player = player;
        this.full = this.plugin.getConfig().getInt("sonic.charge_level");
        this.amount = (int)Math.ceil(this.plugin.getConfig().getDouble("sonic.charge_level") / this.plugin.getConfig().getDouble("sonic.charge_interval"));
    }

    @Override
    public void run() {
        Entity entity = this.plugin.getServer().getEntity(this.display_uuid);
        if (entity instanceof ItemDisplay) {
            ResultSetArtronLeveID rsa;
            ItemDisplay display = (ItemDisplay)entity;
            ItemStack is = display.getItemStack();
            if (is == null || !is.hasItemMeta()) {
                this.cancel();
            }
            if (!(rsa = new ResultSetArtronLeveID(this.plugin, this.id)).resultset() || rsa.getArtronLevel() < this.amount) {
                TARDISSounds.playTARDISSound(this.interaction.getLocation(), "charge_fail");
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "DOCK_ENERGY");
                this.cancel();
            } else {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", this.id);
                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -this.amount, where, null);
            }
            ItemMeta im = is.getItemMeta();
            PersistentDataContainer pdc = im.getPersistentDataContainer();
            if (!pdc.has(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER)) {
                pdc.set(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER, (Object)this.amount);
                is.setItemMeta(im);
                display.setItemStack(is);
                this.setTextDisplay(this.interaction, this.amount);
            } else {
                int current = (Integer)pdc.get(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER);
                if (current < this.full - this.amount) {
                    int charge = current + this.amount;
                    pdc.set(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER, (Object)charge);
                    is.setItemMeta(im);
                    display.setItemStack(is);
                    this.setTextDisplay(this.interaction, charge);
                } else {
                    pdc.set(this.plugin.getSonicChargeKey(), PersistentDataType.INTEGER, (Object)this.full);
                    is.setItemMeta(im);
                    display.setItemStack(is);
                    this.setTextDisplay(this.interaction, this.full);
                    TARDISSounds.playTARDISSound(this.interaction.getLocation(), "charge_done");
                    this.cancel();
                }
            }
        } else {
            this.cancel();
        }
    }

    public void setTask(int task) {
        this.task = task;
    }

    private void cancel() {
        this.plugin.getServer().getScheduler().cancelTask(this.task);
        this.task = 0;
        if (this.text != null) {
            this.text.remove();
        }
    }

    private void setTextDisplay(Interaction interaction, int amount) {
        this.text = TARDISDisplayItemUtils.getText(interaction);
        if (this.text == null) {
            this.text = (TextDisplay)interaction.getLocation().getWorld().spawnEntity(interaction.getLocation().clone().add(0.0, 0.65, 0.0), EntityType.TEXT_DISPLAY);
        }
        if (this.text.isValid()) {
            this.text.setTransformation(this.transformation);
            this.text.setSeeThrough(true);
            this.text.setBillboard(Display.Billboard.VERTICAL);
            this.text.text((Component)Component.text((String)("Sonic Dock: " + amount)));
        }
    }
}

