/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.console.telepathic;

import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIMap;
import me.eccentric_nz.TARDIS.travel.TARDISStructureTravel;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Registry;
import org.bukkit.generator.structure.Structure;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISTelepathicStructure
implements InventoryHolder {
    private final TARDIS plugin;
    private final Registry<Structure> structures = RegistryAccess.registryAccess().getRegistry(RegistryKey.STRUCTURE);
    private final Inventory inventory;

    public TARDISTelepathicStructure(TARDIS plugin) {
        this.plugin = plugin;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Telepathic Structure Finder", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getButtons());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getButtons() {
        ItemStack end;
        ItemStack is;
        ItemStack[] stack = new ItemStack[54];
        int i = 0;
        for (Structure structure : TARDISStructureTravel.overworldStructures) {
            stack[i] = is = this.make(structure, Material.GRASS_BLOCK);
            ++i;
        }
        for (Structure structure : TARDISStructureTravel.netherStructures) {
            stack[i] = is = this.make(structure, Material.CRIMSON_NYLIUM);
            ++i;
        }
        stack[i] = end = this.make(Structure.END_CITY, Material.PURPUR_BLOCK);
        ItemStack close = ItemStack.of((Material)GUIMap.BUTTON_CLOSE.material(), (int)1);
        ItemMeta gui = close.getItemMeta();
        gui.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        gui.setItemModel(GUIMap.BUTTON_CLOSE.key());
        close.setItemMeta(gui);
        stack[53] = close;
        return stack;
    }

    private ItemStack make(Structure structure, Material material) {
        ItemStack is = ItemStack.of((Material)material, (int)1);
        ItemMeta im = is.getItemMeta();
        if (material == Material.GRASS_BLOCK) {
            CustomModelDataComponent component = im.getCustomModelDataComponent();
            component.setColors(List.of(Color.GREEN));
            im.setCustomModelDataComponent(component);
        }
        im.displayName((Component)Component.text((String)TARDISStringUtils.capitalise(this.structures.getKey((Keyed)structure).getKey())));
        is.setItemMeta(im);
        return is;
    }
}

