/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.TARDISARSInventory;
import me.eccentric_nz.TARDIS.ARS.TARDISARSMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.TARDISCircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.chameleon.gui.TARDISChameleonInventory;
import me.eccentric_nz.TARDIS.commands.dev.SystemTreeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISHideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TARDISRebuildCommand;
import me.eccentric_nz.TARDIS.companionGUI.TARDISCompanionAddInventory;
import me.eccentric_nz.TARDIS.companionGUI.TARDISCompanionInventory;
import me.eccentric_nz.TARDIS.control.TARDISControlInventory;
import me.eccentric_nz.TARDIS.control.TARDISInfoMenuButton;
import me.eccentric_nz.TARDIS.control.TARDISPowerButton;
import me.eccentric_nz.TARDIS.control.TARDISRandomButton;
import me.eccentric_nz.TARDIS.control.TARDISScanner;
import me.eccentric_nz.TARDIS.control.TARDISThemeButton;
import me.eccentric_nz.TARDIS.control.actions.DirectionAction;
import me.eccentric_nz.TARDIS.control.actions.FastReturnAction;
import me.eccentric_nz.TARDIS.control.actions.SiegeAction;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lights.TARDISLightsInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.move.TARDISBlackWoolToggler;
import me.eccentric_nz.TARDIS.playerprefs.TARDISPrefsMenuInventory;
import me.eccentric_nz.TARDIS.rooms.TARDISExteriorRenderer;
import me.eccentric_nz.TARDIS.transmat.TARDISTransmatInventory;
import me.eccentric_nz.TARDIS.travel.TARDISAreasInventory;
import me.eccentric_nz.TARDIS.travel.TARDISTemporalLocatorInventory;
import me.eccentric_nz.TARDIS.travel.TARDISTerminalInventory;
import me.eccentric_nz.TARDIS.travel.dialog.TerminalDialog;
import me.eccentric_nz.TARDIS.travel.save.TARDISSavesPlanetInventory;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TARDISControlMenuListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISControlMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onControlMenuInteract(InventoryClickEvent event) {
        Inventory inventory = event.getInventory();
        if (!(inventory.getHolder(false) instanceof TARDISControlInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        if (slot < 0 || slot > 53) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack is = view.getItem(slot);
        if (is == null) {
            return;
        }
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> wheres = new HashMap<String, Object>();
        wheres.put("uuid", uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheres, false);
        if (!rst.resultSet()) {
            return;
        }
        int id = rst.getTardis_id();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            return;
        }
        Tardis tardis = rs.getTardis();
        if (!tardis.isTardisInit()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_INIT");
            return;
        }
        if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn() && slot != 6 && slot != 13 && slot != 20) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
            return;
        }
        if (!tardis.isHandbrakeOn()) {
            switch (slot) {
                case 4: 
                case 11: 
                case 13: 
                case 40: {
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) break;
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_TRAVELLING");
                    return;
                }
            }
        }
        boolean lights = tardis.isLightsOn();
        int level = tardis.getArtronLevel();
        TARDISCircuitChecker tcc = null;
        if (this.plugin.getConfig().getBoolean("difficulty.circuits")) {
            tcc = new TARDISCircuitChecker(this.plugin, id);
            tcc.getCircuits();
        }
        switch (slot) {
            case 0: {
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (tcc != null && !tcc.hasInput() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INPUT_MISSING");
                    return;
                }
                this.close(player, false);
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISRandomButton(this.plugin, player, id, level, 0, tardis.getCompanions(), tardis.getUuid()).clickButton(), 2L);
                break;
            }
            case 2: {
                if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.ROOM_GROWING)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Room Growing");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (!this.plugin.getUtils().canGrowRooms(tardis.getChunk())) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_OWN_WORLD");
                    return;
                }
                if (!TARDISPermission.hasPermission(player, "tardis.architectural")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_ROOMS");
                    return;
                }
                if (tcc != null && !tcc.hasARS() && !this.plugin.getUtils().inGracePeriod(player, true)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_MISSING");
                    return;
                }
                player.openInventory(new TARDISARSInventory(this.plugin, player).getInventory());
                break;
            }
            case 4: {
                if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.CHAMELEON_CIRCUIT)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Chameleon Circuit");
                    return;
                }
                if (tcc != null && !tcc.hasChameleon()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHAM_MISSING");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_DISPERSED");
                    return;
                }
                player.openInventory(new TARDISChameleonInventory(this.plugin, tardis.getAdaption(), tardis.getPreset(), tardis.getItemPreset()).getInventory());
                break;
            }
            case 6: {
                this.close(player, true);
                this.plugin.getMessenger().sendArtron(player, id, 0);
                break;
            }
            case 8: {
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                int zero_amount = this.plugin.getArtronConfig().getInt("zero");
                if (level < zero_amount) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ZERO_ENERGY");
                    return;
                }
                Location zero = TARDISStaticLocationGetters.getLocationFromDB(tardis.getZero());
                if (zero != null) {
                    this.close(player, false);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ZERO_READY");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new TARDISExteriorRenderer(this.plugin).transmat(player, COMPASS.SOUTH, zero), 20L);
                    this.plugin.getTrackerKeeper().getZeroRoomOccupants().add(uuid);
                    HashMap<String, Object> wherez = new HashMap<String, Object>();
                    wherez.put("tardis_id", id);
                    this.plugin.getQueryFactory().alterEnergyLevel("tardis", -zero_amount, wherez, player);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_ZERO");
                break;
            }
            case 9: 
            case 18: {
                if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.SAVES)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                    return;
                }
                int whichId = tardis.getTardisId();
                if (slot == 18) {
                    int pid;
                    ResultSetTardisID tstid = new ResultSetTardisID(this.plugin);
                    if (tstid.fromUUID(uuid.toString()) && whichId != (pid = tstid.getTardisId())) {
                        whichId = pid;
                        this.plugin.getTrackerKeeper().getSavesIds().put(uuid, pid);
                    }
                } else {
                    this.plugin.getTrackerKeeper().getSavesIds().remove(uuid);
                }
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (tcc != null && !tcc.hasMemory()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                    return;
                }
                player.openInventory(new TARDISSavesPlanetInventory(this.plugin, whichId, player).getInventory());
                break;
            }
            case 11: {
                if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.DESKTOP_THEME)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Desktop Theme");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (!TARDISPermission.hasPermission(player, "tardis.upgrade")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_UPGRADE");
                    return;
                }
                new TARDISThemeButton(this.plugin, player, tardis.getSchematic(), level, id).clickButton();
                break;
            }
            case 13: {
                this.close(player, true);
                new SiegeAction(this.plugin).clickButton(tcc, player, tardis.isPoweredOn(), id);
                break;
            }
            case 15: {
                this.close(player, false);
                new TARDISScanner(this.plugin).scan(id, player, tardis.getRenderer(), level);
                break;
            }
            case 17: {
                player.openInventory(new TARDISPrefsMenuInventory(this.plugin, uuid).getInventory());
                break;
            }
            case 20: {
                if (this.plugin.getConfig().getBoolean("allow.power_down")) {
                    if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                        this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_IN_VORTEX");
                        return;
                    }
                    this.close(player, true);
                    new TARDISPowerButton(this.plugin, id, player, tardis.getPreset(), tardis.isPoweredOn(), tardis.isHidden(), lights, player.getLocation(), level, tardis.getSchematic().getLights()).clickButton();
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN_DISABLED");
                break;
            }
            case 22: {
                this.close(player, true);
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                new TARDISHideCommand(this.plugin).hide((OfflinePlayer)player);
                break;
            }
            case 24: {
                this.close(player, false);
                new TARDISInfoMenuButton(this.plugin, player).clickButton();
                break;
            }
            case 26: {
                String comps = tardis.getCompanions();
                if (comps == null || comps.isEmpty()) {
                    this.close(player, true);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new TARDISCompanionAddInventory(this.plugin, player).getInventory()), 2L);
                    return;
                }
                String[] companionData = comps.split(":");
                player.openInventory(new TARDISCompanionInventory(this.plugin, companionData).getInventory());
                break;
            }
            case 27: {
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (tcc != null && !tcc.hasInput() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INPUT_MISSING");
                    return;
                }
                this.close(player, false);
                new FastReturnAction(this.plugin).clickButton(player, id, tardis);
                break;
            }
            case 29: {
                player.openInventory(new TARDISLightsInventory(this.plugin, id, player.getUniqueId()).getInventory());
                break;
            }
            case 31: {
                this.close(player, true);
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                new TARDISRebuildCommand(this.plugin).rebuildPreset((OfflinePlayer)player);
                break;
            }
            case 33: {
                player.openInventory(new TARDISTransmatInventory(this.plugin, id, player).getInventory());
                break;
            }
            case 35: {
                new SystemTreeCommand(this.plugin).open(player);
                break;
            }
            case 36: {
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (tcc != null && !tcc.hasMemory()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                    return;
                }
                player.openInventory(new TARDISAreasInventory(this.plugin, player).getInventory());
                break;
            }
            case 38: {
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                this.close(player, true);
                new TARDISBlackWoolToggler(this.plugin).toggleBlocks(id, player);
                break;
            }
            case 40: {
                String direction = new DirectionAction(this.plugin).rotate(id, player);
                if (direction.isEmpty()) break;
                ItemStack d = view.getItem(40);
                ItemMeta im = d.getItemMeta();
                im.lore(List.of(Component.text((String)direction)));
                d.setItemMeta(im);
                break;
            }
            case 45: {
                if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(id)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CONTROL");
                    return;
                }
                if (level < this.plugin.getArtronConfig().getInt("travel")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ENERGY");
                    return;
                }
                if (tcc != null && !tcc.hasInput() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "INPUT_MISSING");
                    return;
                }
                ResultSetPlayerPrefs rspp = new ResultSetPlayerPrefs(this.plugin, player.getUniqueId().toString());
                if (!rspp.resultSet()) break;
                if (rspp.isDialogsOn()) {
                    this.close(player, false);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> Audience.audience((Audience[])new Audience[]{player}).showDialog((DialogLike)new TerminalDialog().create()), 2L);
                    break;
                }
                player.openInventory(new TARDISTerminalInventory(this.plugin).getInventory());
                break;
            }
            case 47: {
                player.openInventory(new TARDISARSMap(this.plugin).getInventory());
                break;
            }
            case 49: {
                if (!TARDISPermission.hasPermission(player, "tardis.temporal")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_TEMPORAL");
                    return;
                }
                if (tcc != null && !tcc.hasTemporal() && !this.plugin.getUtils().inGracePeriod(player, false)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TEMP_MISSING");
                    return;
                }
                player.openInventory(new TARDISTemporalLocatorInventory(this.plugin).getInventory());
                break;
            }
            case 51: {
                ItemStack spt = view.getItem(51);
                ItemMeta im = spt.getItemMeta();
                String currentThrottle = ComponentUtils.stripColour((Component)im.lore().getFirst());
                int delay = SpaceTimeThrottle.valueOf(currentThrottle).getDelay() - 1;
                if (delay < 1) {
                    delay = 4;
                }
                if (delay != 4 && this.plugin.getConfig().getBoolean("difficulty.system_upgrades")) {
                    switch (delay) {
                        case 3: {
                            if (new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.FASTER)) break;
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Faster");
                            delay = 4;
                            break;
                        }
                        case 2: {
                            if (new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.RAPID)) break;
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Rapid");
                            delay = 3;
                            break;
                        }
                        case 1: {
                            if (new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.WARP)) break;
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Warp");
                            delay = 2;
                            break;
                        }
                    }
                }
                String throttle = SpaceTimeThrottle.getByDelay().get(delay).toString();
                im.lore(List.of(Component.text((String)throttle)));
                spt.setItemMeta(im);
                HashMap<String, Object> wherer = new HashMap<String, Object>();
                wherer.put("uuid", uuid.toString());
                HashMap<String, Object> setr = new HashMap<String, Object>();
                setr.put("throttle", delay);
                this.plugin.getQueryFactory().doUpdate("player_prefs", setr, wherer);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "THROTTLE", throttle);
                break;
            }
            case 53: {
                this.close(player, false);
                break;
            }
        }
    }

    private void close(Player p, boolean check) {
        ResultSetPlayerPrefs rspp;
        boolean close = true;
        if (check && (rspp = new ResultSetPlayerPrefs(this.plugin, p.getUniqueId().toString())).resultSet()) {
            close = rspp.isCloseGUIOn();
        }
        if (close) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ((Player)p).closeInventory(), 1L);
        }
    }
}

