/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

class TARDISSQLUpdate
implements Runnable {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String table;
    private final HashMap<String, Object> data;
    private final HashMap<String, Object> where;
    private final String prefix;

    TARDISSQLUpdate(TARDIS plugin, String table, HashMap<String, Object> data, HashMap<String, Object> where) {
        this.plugin = plugin;
        this.table = table;
        this.data = data;
        this.where = where;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Statement ps = null;
        StringBuilder sbu = new StringBuilder();
        StringBuilder sbw = new StringBuilder();
        this.data.forEach((key, value) -> sbu.append((String)key).append(" = ?,"));
        this.where.forEach((key, value) -> {
            sbw.append((String)key).append(" = ");
            if (value instanceof String || value instanceof UUID) {
                sbw.append("'").append(value).append("' AND ");
            } else {
                sbw.append(value).append(" AND ");
            }
        });
        this.where.clear();
        String updates = sbu.substring(0, sbu.length() - 1);
        String wheres = sbw.substring(0, sbw.length() - 5);
        String query = "UPDATE " + this.prefix + this.table + " SET " + updates + " WHERE " + wheres;
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement(query);
            int s = 1;
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                    ps.setString(s, entry.getValue().toString());
                }
                Object object = entry.getValue();
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Double.class, Float.class, Long.class}, (Object)object, n)) {
                    case 0: {
                        Integer i = (Integer)object;
                        ps.setInt(s, i);
                        break;
                    }
                    case 1: {
                        Double v = (Double)object;
                        ps.setDouble(s, v);
                        break;
                    }
                    case 2: {
                        Float v = (Float)object;
                        ps.setFloat(s, v.floatValue());
                        break;
                    }
                    case 3: {
                        Long l = (Long)object;
                        ps.setLong(s, l);
                        break;
                    }
                    default: {
                        ps.setObject(s, entry.getValue());
                    }
                }
                ++s;
            }
            this.data.clear();
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for " + this.table + "! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing " + this.table + "! " + e.getMessage());
            }
        }
    }
}

